import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet creates a mailing list for the admin.
 * 
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 18:03:17 IST 2000
 */

public class CreateMailingList extends HttpServlet {

	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** 
	  * Print the form to get email ids of the ppl in this mailing list
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!whoisit.equalsIgnoreCase("Admin")) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  /* Print form */
		  ShowStuff.printHeader("Create Mailing List",out);
		  //out.println("<body>");

		  ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/CreateMailingList",out);
		  out.println("<table width=600 border=0 cellspacing=0 cellpadding=0>");

		  
		  out.println("<tr><td width=200>Please enter the Id (max 5 chars) you want to assign to this mailing list.</td><td>&nbsp;</td></tr>");
		  //ShowStuff.textBox("ListId",10,5,out);
		  //out.println("<tr> Max 5 characters<br><br>");
		  out.println("<tr><td width=200><font class=TDFONT size=2></font></td><td30><input type=\"text\" name=ListId size=10 maxlength=5></td></tr>");
		  out.println("<tr><td width=200> Please enter email ids for the mailing list in the text-area (One email id per row)<br></td><td>&nbsp;</td></tr>");
		  out.println("<tr><td width=200><textarea name=\"emails\" rows=10 cols=38></textarea></td><td>&nbsp</td></tr>");
		  out.println("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
          out.println("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
          out.println("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
		  out.println("<tr><td>&nbsp;</td><td><input type=\"Submit\" value=\"Create\"></td></tr>");
		  out.println("</table></form>");
		  ShowStuff.printFooter(out);
	 }

	 /** 
	  * Create the mailing list
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!whoisit.equalsIgnoreCase("Admin")) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ListId=req.getParameter("ListId");
		  String ID=(String)session.getValue("ID");

		  Connection con=null;
		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();

			   String createStatement="INSERT INTO MAILINGLIST VALUES(?,?)";

			   /* Use prepared statement */
			   PreparedStatement pst;

			   StringTokenizer stz=new StringTokenizer(req.getParameter("emails"),"\n");
			   while (stz.hasMoreTokens()) {
					pst=con.prepareStatement(createStatement);
					pst.setString(1,ListId);
					pst.setString(2,(String)stz.nextToken());
					pst.executeUpdate();
			   }

			   con.close();    /* Close the connection */
			   /* Print OK page */
			   ShowStuff.printHeader("Created Mailing List",out);
			   out.println("<body>");
			   out.println("<font color=blue>Mailing List \""+ListId+"\" has been created.</font><br><br><hr size=1>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+whoisit+"Servlet\">here</a> to go to your main page.<br><hr size=1>");
			   ShowStuff.printFooter(out);
		  } catch (Exception e) { e.printStackTrace(); ShowStuff.throwError("Error","Couldnt create mailing list",out); if (con != null) {con=null; } }
	 }
}
