
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import util.*;

/** 
 * This servlet takes a file name as parameter from calling HTML code
 * and generates request to download the file from the server to the 
 * client. 
 *
 * @author Mithun Arora
 * 
 */

public class Download extends HttpServlet
{

	/* Initialise the servlet */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/**
	 * Checks for session validity, gets the filename to be downloaded,
	 * and generates appropriate response.
	 *
	 * @param req HttpServletRequest
	 * @param res HttpServletResponse
	 */ 
	public void doGet(HttpServletRequest req, HttpServletResponse res) 
		throws ServletException,IOException 
		{
			HttpSession session=req.getSession(false);

			/* Check session validity. Only reviewers allowed */
			String whoisit=(String)session.getValue("whoami");
			if ((whoisit==null) || ((!(whoisit.equalsIgnoreCase("Reviewer"))) && (!whoisit.equalsIgnoreCase("Admin")))) {
				throw new UnavailableException(this,"Invalid Access Attempt");
			}

			String filename=req.getParameter("filename");
         res.setContentType("application/x-filler"); 
         res.setHeader("Content-Disposition", 
                        "filename="+filename+";"); 
         ServletOutputStream stream = res.getOutputStream(); 
       //  BufferedInputStream fif =  
          //   new BufferedInputStream(new FileInputStream(filename)); 
         FileInputStream fif=new FileInputStream(filename);
			int data; 
         while((data = fif.read()) != -1) { 
             stream.write(data); 
         } 
         fif.close(); 
         stream.close();
		} 
 }
