import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet gets all the personal information of the admin or the reviewer 
 * when he logs in for the first time.
 * 
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 17:34:55 IST 2000
 */


public class FirstLoginServlet extends HttpServlet {

	 static String PersonAttr[];        /* Attributes of PERSON Table */
	 static String ReviewerAttr[];   /* Attributes of REVIEWER Table */
	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);

		  Connection con=null;
		  try {                                                                         
			   /* Open connection */                                                    
			   con=DB.getConnection();                                                  


			   Statement st=con.createStatement();                                      

			   /* Get schema info for the Reviewer,Admin */ 
			   ResultSet rs=st.executeQuery("SELECT * FROM PERSON");                    
			   ResultSetMetaData rt=rs.getMetaData();                                   
			   int cnt=rt.getColumnCount();                                             
			   PersonAttr=new String[cnt];                                              
			   for (int i=1; i<=cnt; i++) {                                             
					PersonAttr[i-1]=rt.getColumnName(i);                                
			   } 

			   rs=st.executeQuery("SELECT * FROM REVIEWER");                         
			   rt=rs.getMetaData();                                                     
			   int cnt2=rt.getColumnCount();                                            
			   ReviewerAttr=new String[cnt2];                                        
			   for (int j=1;j<=cnt2;j++) {                                              
					ReviewerAttr[j-1]=rt.getColumnName(j);                           
			   }                                         

			   con.close();
		  } catch (SQLException e) {                                                    
			   if (con != null) { con=null; } 
			   throw new UnavailableException(this,"Couldnt get db connection");        
		  }                                                                             


	 }

	 /**
	  * @param req HttpServletRequest
	  * @param req HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Checking that the user is Admin or Reviewer only.*/
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer") || whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");   /* Id of the user */

		  session.removeValue("whoami");  /* This is done to prevent him from leaving this page */
		  session.removeValue("ID");      /* without giving in this personal information */

		  session.putValue("thisguyis",whoisit); /* Used by doPost servlet to enter this info in DB*/
		  session.putValue("emailId",ID);

		  res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
		  if (whoisit.equalsIgnoreCase("Reviewer")) {
			   res.setHeader("Location","http://"+Config._HTMLROOT+"revinfo.html");
		  } else {
			   res.setHeader("Location","http://"+Config._HTMLROOT+"admininfo.html");
		  }


	 }


	 public void doPost(HttpServletRequest req,HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  String whoisit=(String)session.getValue("thisguyis");

		  if (whoisit==null) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("emailId");

		  Connection con=null;
		  String update;
		  PreparedStatement pst;
		  String pwd="";
		  
		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();

			   if (whoisit.equalsIgnoreCase("Reviewer")) {
					ResultSet rs=st.executeQuery("SELECT PASSWORD FROM REVIEWER WHERE EMAIL='"+ID+"'");
					if (rs.next()) {
						 pwd=rs.getString(1);
					}
			   }

			   update="UPDATE PERSON SET ";                                       
			   for (int i=0; i<PersonAttr.length;i++) {                                   
					update += (i==0) ? "" : ", ";                                          
					update +=PersonAttr[i].toUpperCase()+"=?";                                                         
			   }                                                                          
			   update += " WHERE EMAIL='"+ID+"'";                                                             
			   pst=con.prepareStatement(update);                                          

			   for (int i=0; i<PersonAttr.length; i++) {                                  
					if (PersonAttr[i].equalsIgnoreCase("email")) {
						 pst.setString(i+1,ID);     
					} else {
						 pst.setString(i+1,req.getParameter(PersonAttr[i].toLowerCase()));     
					}
			   }                                                                          
			   pst.executeUpdate();                                                       

			   if (whoisit.equalsIgnoreCase("Reviewer")) {

					update="UPDATE REVIEWER SET ";                                  
					for (int i=0; i<ReviewerAttr.length; i++) {                             
						 update += (i==0) ? "" : ", ";                                          
						 update += ReviewerAttr[i].toUpperCase()+"=?";                                                        
					}                                                                          
					update += " WHERE EMAIL='"+ID+"'";                                                             
					pst=con.prepareStatement(update);            

					for (int i=0; i<ReviewerAttr.length; i++) {                             
						 if (ReviewerAttr[i].equalsIgnoreCase("email")) {
							  pst.setString(i+1,ID);     
						 } else {
							  if (ReviewerAttr[i].equalsIgnoreCase("password")) {
								   pst.setString(i+1,pwd);
							  } else {
								   pst.setString(i+1,req.getParameter(ReviewerAttr[i].toLowerCase()));
							  }
						 }
					}                                                                          
					pst.executeUpdate();                                 
			   }

			   con.close();

			   session.removeValue("thisguyis");
			   session.removeValue("emailId");

			   session.putValue("whoami",whoisit);
			   session.putValue("ID",ID);

			   res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
			   res.setHeader("Location","http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit));


		  } catch (SQLException e) { e.printStackTrace();  ShowStuff.throwError("Database Access Error",out); if (con != null) con=null; } 

	 }
}
