import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** This servlet checks the userId and password for the user and then if valid, takes him 
 *  to his servlet eg the reviewer to ReviewerServlet.It also enters the necessary info 
 *  into the session.
 *  NOTE: The userId for contact-author will be the paperId given to him for
 *        that paper.  
 *
 *  @author    Aameek Singh
 *  @version   1.00, Fri Sep 29 17:26:41 IST 2000
 */


public class LoginServlet extends HttpServlet {


	 /** Initialise the servlet
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }


	 /**
	  * Checks whether the username and password are valid
	  * If yes, then redirect to the appropriate servlet.
	  * @param req HttpServletRequest  - the request 
	  * @param res HttpServletResponse - the response for the request
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);   /* Create a Session */
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  String whoami=(String)req.getParameter("whoami");  /* Who is logging in */
		  String id=(String)req.getParameter("userId");      /* The userId */
		  String passwd=(String)req.getParameter("passwd");  /* The password */

		  Connection con=null;

		  try {
			   /* Open a DB connection */
			   con=DB.getConnection(); 

			   ResultSet rs;

			   String validateQuery="SELECT * FROM ";

			   /* For author, the userId and pwd are to be checked in table PAPER 
				* For others, it is in simply $whoit */
			   if (whoami.equalsIgnoreCase("author")) {
					validateQuery+="PAPER WHERE (PAPERID='";
			   } else {
					validateQuery+=whoami.toUpperCase()+" WHERE (EMAIL='";
			   }
			   validateQuery+=id+"') AND (PASSWORD=?)";

			   /* Using PreparedStatement to prevent a "'" gotch! */
			   PreparedStatement pst=con.prepareStatement(validateQuery);
			   pst.setString(1,passwd);
			   rs=pst.executeQuery();

			   /* Yes, there exists such a user */
			   if (rs.next()) {
					session.putValue("whoami",whoami);  /* Put info abt who the user is */
					session.putValue("ID",id);          /* Put info abt his userId */
					con.close();                        /* Close Connection */

					/* checking if logging in for the first time */
					if ( ((whoami.equalsIgnoreCase("Admin")) || (whoami.equalsIgnoreCase("Reviewer"))) && (DB.firstLogin(whoami,id)) ) {
						 res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
						 res.setHeader("Location","http://"+Config._HOST+":"+Config._PORT+"/servlet/FirstLoginServlet");
					} else {
						 if (whoami.equalsIgnoreCase("Author")) {
							  java.util.Date PresentDate=new java.util.Date();
							  if (PresentDate.before(Gen.getPaperSubmissionDeadline())) {
								   res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
								   res.setHeader("Location","http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoami));
							  } else {  /* Not allowed to login now */
								   session.invalidate();
								   ShowStuff.printHeader("Submission Date Passed",out);
								   out.println("Submission Date Has Passed. Cannot Login.");
								   ShowStuff.printFooter(out);
							  }
						 } else {
							  res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
							  res.setHeader("Location","http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoami));
						 }

					}
			   } else {                   /* No such user */
					ShowStuff.throwError("Invalid Username/Password","Invalid User Name or Password. <p> Please try again.<p><br></br><p>",out);
					con.close();
			   }
		  } catch (SQLException e) { e.printStackTrace(); ShowStuff.throwError("Database Access Error",out); if (con!=null) { con=null; }}
	 }
}
