import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** This servlet sets a flag in the DB which indicates that the admin 
 *  has finally assigned the papers to the reviewers so that the reviewers
 *  can proceed to stage 2
 *  @author Aameek Singh
 *  @version 1.00, Sun Nov 12 17:21:02 IST 2000
 */
public class MarkAssigned extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig 
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** Set the flag and take the admin back to his main page
	  *  @param req HttpServletRequest
	  *  @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(false);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity. Only admin allowed */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  Connection con=null;
		  String ID=(String)session.getValue("ID");

		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();
			   st.executeUpdate("UPDATE FLAG SET VAL=1");
			   res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
			   res.setHeader("Location","http://"+Config._HOST+":"+Config._PORT+"/servlet/AdminServlet");
		  } catch (SQLException e) { e.printStackTrace(); ShowStuff.throwError("Database Access Error",out); if (con!=null) { con=null; }}
	 }
}
