import java.util.*;
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;


/** this servlet accepts registrations from participants.
 *
 * @author Anjali Gupta
 * @version 1.00 Mon Nov 13 21:22:02 IST 2000
 */ 

public class ParticipantServlet extends HttpServlet 
{

	 private Connection con=null;       /* A single connection will serve all clients */
	 static String PersonAttr[];        /* Attributes of PERSON Table */
	 static String ParticipantAttr[];   /* Attributes of PARTICIPANT Table */
	 static String BookingsAttr[];      /* Attributes of BOOKINGS Table */
	 static String ParticipationAttr[]; /* Attributes of PARTICIPATION Table */
	 static String PaymentsAttr[];      /* Attributes of PAYNMENTS Table */
	 static String CreditCardPaymentAttr[];  /* Attributes of CREDITCARDPAYMENT Table */
	 static String ChequePaymentAttr[];      /* Attributes of CHEQUEPAYMENT Table */
	 static String DemandDraftPaymentAttr[]; /* Attributes of DEMANDDRAFTPAYMENT Table */
	 static String EventParticipationAttr[]; /* Attributes of EVENTPARTICIPATION Table */
	 static int NoOfEvents;

	 /** Initialise the servlet
	  *  Open a database connection and get the attributes of the PERSON,PARTICIPANT tables 
	  *  @param config ServletConfig
	  */
	 
	 public void init(ServletConfig config) throws ServletException 
	 {
		  super.init(config);
		  
		  try {
			   /* Open connection */
			   con=DB.getConnection();


			   Statement st=con.createStatement();

			   /* Get schema info for the participant (ie PERSON + PARTICIPANT attr) */ 
			   ResultSet rs=st.executeQuery("SELECT * FROM PERSON");
			   ResultSetMetaData rt=rs.getMetaData();
			   int cnt=rt.getColumnCount();
			   PersonAttr=new String[cnt];
			   for (int i=1; i<=cnt; i++) {
					PersonAttr[i-1]=rt.getColumnName(i);
			   }
			   /* Get Schema info for all the required Tables */
			   rs=st.executeQuery("SELECT * FROM PARTICIPANT");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   ParticipantAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					ParticipantAttr[j-1]=rt.getColumnName(j);
			   }

			   rs=st.executeQuery("SELECT * FROM BOOKINGS");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   BookingsAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					BookingsAttr[j-1]=rt.getColumnName(j);
			   }

			   rs=st.executeQuery("SELECT * FROM PARTICIPATION");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   ParticipationAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					ParticipationAttr[j-1]=rt.getColumnName(j);
			   }

			   rs=st.executeQuery("SELECT * FROM EVENTPARTICIPATION");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   EventParticipationAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					EventParticipationAttr[j-1]=rt.getColumnName(j);
			   }
			   NoOfEvents=0;

			   rs=st.executeQuery("SELECT COUNT(*) FROM EVENTPARTICIPATION");
			   while (rs.next())
			   {
					NoOfEvents = Integer.parseInt(rs.getString(1));
			   }

			   rs=st.executeQuery("SELECT * FROM PAYMENT");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   PaymentsAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					PaymentsAttr[j-1]=rt.getColumnName(j);
			   }

			   rs=st.executeQuery("SELECT * FROM CREDITCARDPAYMENT");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   CreditCardPaymentAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					CreditCardPaymentAttr[j-1]=rt.getColumnName(j);
			   }

			   rs=st.executeQuery("SELECT * FROM CHEQUEPAYMENT");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   ChequePaymentAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					ChequePaymentAttr[j-1]=rt.getColumnName(j);
			   }


			   rs=st.executeQuery("SELECT * FROM DEMANDDRAFTPAYMENT");
			   rt=rs.getMetaData();
			   cnt=rt.getColumnCount();
			   DemandDraftPaymentAttr=new String[cnt];
			   for (int j=1;j<=cnt;j++) {
					DemandDraftPaymentAttr[j-1]=rt.getColumnName(j);
			   }

		  } catch (SQLException e) 
		  {
			   System.out.println(e); 
		  }
	 }

	 /** Store all the submitted values in the database in appropriate tables 
	  *  
	  *  @param req HttpServletRequest
	  *  @param res HttpServletResponse
	  */

	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException,IOException 
	 {
		  
		  res.setContentType("text/html");
		  PrintWriter out= res.getWriter();
		  PreparedStatement pst=null; /* Use prepared statement to prevent error of 
										 a "'" in any value        */
		  String update="";


		  try {
			  
			   // Before making any changes we must check that the person has not already
			   // been included in the person table of our database. If the person figures
			   // in there we decide that the person has either already been registered 
			   // or is a reviewer/ contact author ...
			   
			   Statement st=con.createStatement();
               ResultSet rs;
               String PersonEmail = req.getParameter("email");
					rs = st.executeQuery("SELECT * FROM PERSON WHERE EMAIL='"+PersonEmail+"'");
					int Count = 0;
					
					while (rs.next())
					{   
						 Count++;  
					}

			   /* updating the PERSON table */
			if (Count == 0)
			{
			   update="INSERT INTO PERSON values(";
			   for (int i=0; i<PersonAttr.length;i++) {
					update += (i==0) ? "" : ",";
					update +="?";
			   }
			   update += ")";
			   pst=con.prepareStatement(update);
			   for (int i=0; i<PersonAttr.length; i++) {
					pst.setString(i+1,req.getParameter(PersonAttr[i].toLowerCase()));
			   }
			   pst.executeUpdate();
			}

			   /* updating the PARTICIPANT table */
			   update="INSERT INTO PARTICIPANT values(";
			   for (int i=0; i<ParticipantAttr.length; i++) {
					update += (i==0) ? "" : ",";
					update += "?";
			   }
			   update += ")";
			   pst=con.prepareStatement(update);
			   for (int i=0; i<ParticipantAttr.length; i++) {
					pst.setString(i+1,req.getParameter(ParticipantAttr[i].toLowerCase()));
			   }
			   pst.executeUpdate();

			   /* updating the BOOKINGS table */
			   update="INSERT INTO BOOKINGS values(";
			   for (int i=0; i<BookingsAttr.length; i++) {
					update += (i==0) ? "" : ",";
					update += "?";
			   }
			   update += ")";
			   pst=con.prepareStatement(update);
			   for (int i=0; i<BookingsAttr.length; i++) {
					pst.setString(i+1,req.getParameter(BookingsAttr[i].toLowerCase()));
			   }
			   pst.executeUpdate();

			   /* updating the PARTICIPATION table */
			   update="INSERT INTO PARTICIPATION values(";
			   for (int i=0; i<ParticipationAttr.length; i++) {
					update += (i==0) ? "" : ",";
					update += "?";
			   }
			   update += ")";
			   pst=con.prepareStatement(update);
			   for (int i=0; i<ParticipationAttr.length; i++) {
					pst.setString(i+1,req.getParameter(ParticipationAttr[i].toLowerCase()));
			   }
			   pst.executeUpdate();

			   for (int j=0;j<=NoOfEvents-1;j++)
			   {
					/* updating the EVENTPARTICIPATION table */
					update="INSERT INTO EVENTPARTICIPATION values(";
					for (int i=0; i<EventParticipationAttr.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					pst=con.prepareStatement(update);
					for (int i=0; i<EventParticipationAttr.length; i++) {
						 if (EventParticipationAttr[i].equalsIgnoreCase("email"))
						 {
							  pst.setString(i+1,req.getParameter("email"));}
						 else{
							  pst.setString(i+1,req.getParameter(EventParticipationAttr[i].toLowerCase()+j+""));
						 }
					}
					pst.executeUpdate();
			   }


			   /* UPDATE THE PAYMENTS TABLE -- Initially the payments and the amount due
				* are all null - later after all program schedules have been finalized, the
				* chair will invoke a function to calculate the bill for each participant*/

			   update="INSERT INTO PAYMENT values(";
			   for (int i=0; i<PaymentsAttr.length; i++) {
					update += (i==0) ? "" : ",";
					update += "?";
			   }
			   update += ")";
			   pst=con.prepareStatement(update);
			   for (int i=0; i<PaymentsAttr.length; i++) 
			   {
					if (PaymentsAttr[i].equalsIgnoreCase("Amount"))
					{
						 pst.setString(i+1,null);
					}
					else 
					{
						 if (PaymentsAttr[i].equalsIgnoreCase("madePayment"))
						 {
							  pst.setInt(i+1,0);
						 }
						 else
						 {

							  pst.setString(i+1,req.getParameter(PaymentsAttr[i].toLowerCase()));
						 }
					}
			   }
			   pst.executeUpdate();

			   String Mode = req.getParameter("paymentmode");

			   if (Mode.equalsIgnoreCase("creditcard"))
			   {
					/* updating the CREDITCARDPAYMENT table */
					update="INSERT INTO CREDITCARDPAYMENT values(";
					for (int i=0; i<CreditCardPaymentAttr.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					pst=con.prepareStatement(update);
					for (int i=0; i<CreditCardPaymentAttr.length; i++) {
						 pst.setString(i+1,req.getParameter(CreditCardPaymentAttr[i].toLowerCase()));
					}
					pst.executeUpdate();
			   }


			   if (Mode.equalsIgnoreCase("cheque"))
			   {
					/* updating the CHEQUEPAYMENT table */
					update="INSERT INTO CHEQUEPAYMENT values(";
					for (int i=0; i<ChequePaymentAttr.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					pst=con.prepareStatement(update);
					for (int i=0; i<ChequePaymentAttr.length; i++) {
						 pst.setString(i+1,req.getParameter(ChequePaymentAttr[i].toLowerCase()));
					}
					pst.executeUpdate();

			   }


			   if (Mode.equalsIgnoreCase("demanddraft"))
			   {
					/* updating the DEMANDDRAFT table */
					update="INSERT INTO DEMANDDRAFTPAYMENT values(";
					for (int i=0; i<DemandDraftPaymentAttr.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					pst=con.prepareStatement(update);
					for (int i=0; i<DemandDraftPaymentAttr.length; i++) {
						 pst.setString(i+1,req.getParameter(DemandDraftPaymentAttr[i].toLowerCase()));
					}
					pst.executeUpdate();

			   }

			   /* Send Mail confirming registration */
			   try {
					Mail.sendMail(req.getParameter("email"),Config._MAIL_ID,"Thanks for registering","Your registration has been confirmed");
			   } catch (Exception e) { }



		  } catch (SQLException e) {System.out.println(e);  
			   ShowStuff.throwError("Database Access Error",out); }

			   ShowStuff.printHeader("Thanks",out);
			   out.println("<body>");
			   out.println("<font color=blue>Thanks for registering with us</font><br>");
			   out.println("<hr size=1>");
			   out.println("<a href=\"http://"+Config._HTMLROOT+"Login.html\">Go Home</a><br><br><br><br><br><br><br><br>");
			   ShowStuff.printFooter(out);
	 }

	 /** 
	  * Do the cleaning up 
	  */
	 public void destroy() {
		  /* close an open database connection */
		  try {
			   if (con != null) con.close();
		  } catch (SQLException e) { }
	 }
}
