import util.*;

import java.io.*;
import java.util.*;
import java.sql.*;


/** 
 * This class generates the html form for Query Engine for participants. 
 * It reads the participant attributes from the database and writes the form
 * in a file in _HTMLROOT.
 * 
 * @author Mithun Arora
 * @version 1.00
 */

public class QueryPage
{
	public static void main(String[] args) throws SQLException, IOException
	{
		FileWriter fw=new FileWriter(Config._HTML_REPOSITORY+"ParticipantQuery.html");
		PrintWriter out=new PrintWriter(fw);
		ShowStuff.printHeader("Participant Query Form", out);
		
		out.println("<p><table width=360 border=0 cellspacing=0 cellpadding=0>");
		out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a></td></tr>");
		out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a></td></tr>");
      		out.println("</table>");
		
		ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/QueryParticipant", out);
		
		try
		{
		 	Connection con=null;
      			Statement stmt=null;
			ResultSet rs=null;
			ResultSetMetaData rsmd=null;
			con=DB.getConnection();
			out.println("<table>");
			out.println("<tr><td> Please select the attributes to be printed from the following. </td></tr>");
			out.println("</table>");
			stmt=con.createStatement();
		        rs=stmt.executeQuery("SELECT * FROM PERSON,PARTICIPANT,BOOKINGS, PARTICIPATION, EVENTPARTICIPATION, PAYMENT, CREDITCARDPAYMENT, CHEQUEPAYMENT, DEMANDDRAFTPAYMENT WHERE PARTICIPANT.EMAIL=PERSON.EMAIL and PARTICIPANT.EMAIL=BOOKINGS.EMAIL and EVENTPARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PAYMENT.EMAIL=PARTICIPANT.EMAIL");
			rsmd=rs.getMetaData();
			int numParams=rsmd.getColumnCount();
        	 	String currParam=null;
			int currType=0;
			
		// the hashtable stores the type of parameter, so that 
		// a textbox for or a menu for numerical types can be made.
			Hashtable paramType= new Hashtable(); 
			String[] allParam = new String[100];
			int paramCount = 0;  //the count of distinct parameters found till now.
			for(int i=1; i<=numParams; i++)
			{
				currParam=(String)rsmd.getColumnName(i);
				currType=rsmd.getColumnType(i);
				if (paramType.get(currParam) == null)//not yet stored in the hashtable, so it is included in the distinct list.
				{
				      allParam[paramCount] = currParam;
				      paramCount++;
				}
		       		paramType.put(currParam,new Integer(currType));
			}
			
			out.println("<table>");
			for(int i=0; i<paramCount; i++)
			{
			  	currParam = allParam[i];
				out.println("<tr><td> <input type=\"checkbox\" name=\""+currParam.toLowerCase()+1+"\" value=\"1\">"+ currParam+"</td>");
				if (currParam.equalsIgnoreCase("email"))
				      out.println("<td><input type=\"text\" name=\""+currParam.toLowerCase()+2+"\" size=50 maxlength=100></td></tr>");
				 else
				      out.println("<td> <input type=\"text\" name=\""+currParam.toLowerCase()+2+"\" size=20 maxlength=50> </td></tr>");
			}
			out.println("</table>");
			out.println("<input type=\"Submit\" value=\"Submit\">");
			out.println("</form>");
			out.println("<br>");
			ShowStuff.printFooter(out);
			//out.println("<br> Please choose the query. Select one of the following. <br>");
		
		// Kranthi please write more such queries as u think r reqd.
			//out.println("<input type=\"radio\" name=\"querytype\" value=\"WHERE  PARTICIPANT.EMAIL=PERSON.EMAIL and PARTICIPANT.EMAIL=BOOKINGS.EMAIL and EVENTPARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PAYMENT.EMAIL=PARTICIPANT.EMAIL and (PAYMENT.EMAIL=CREDITCARDPAYMENT.EMAIL or PAYMENT.EMAIL=CHEQUEPAYMENT.EMAIL or PAYMENT.EMAIL=DEMANDDRAFTPAYMENT.EMAIL)\" > All Partcipants <br>");
			//out.println("<input type=\"radio\" name=\"querytype\" value=\"WHERE  PARTICIPANT.EMAIL=PERSON.EMAIL and PARTICIPANT.EMAIL=BOOKINGS.EMAIL and EVENTPARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PAYMENT.EMAIL=PARTICIPANT.EMAIL and PAYMENT.MADEPAYMENT=0\"> Participants who have not made the payment. <br>");
	
         
				
		//out.println("<input type=\"radio\" name=\"querytype\" value=\"SPECIALIZED\"> For other general queries kindly fill in the table below");
		//for(int i=1; i<=numParams; i++)
		//
				

	// special fields here r :
	// *checkin checkout dates in bookings. 
	// *madepayment in payment

		}
		catch(SQLException e) { System.out.println(e);}
		out.close();
	}
}
