import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet prints the results of the query that the admin has chosen to 
 * execute for reviewers and papers.
 * @author Kranthi Kumar
 * @version 1.00
 */

public class QueryReviewer extends HttpServlet {
  	public void init(ServletConfig config) throws ServletException {
	  	super.init(config);
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
	{
	  	HttpSession session = req.getSession(false);
		res.setContentType("text/html");
		PrintWriter out = res.getWriter();
		Connection con = null;
		int reviewQueryNo = 5; //the query no of the query that gets the details of a review.
		int queryNo = Integer.parseInt((String)req.getParameter("query")); 
		//queryNo is the no. of the position in the array queries which is to be executed.
		String paperId = "";
		String queries[] = {
		  		     "SELECT PAPERID, TITLE FROM PAPER",
				     "SELECT PAPERID,AUTHOR.EMAIL,NAME FROM AUTHOREDBY,AUTHOR WHERE AUTHOREDBY.EMAIL=AUTHOR.EMAIL",
				     "SELECT PAPERID, AUTHOR.EMAIL, AUTHOR.NAME FROM AUTHOREDBY, AUTHOR WHERE AUTHOREDBY.EMAIL=AUTHOR.EMAIL AND ISCONTACT='1'",
				     "SELECT EMAIL FROM REVIEWER",
				     "SELECT PERSON.EMAIL, NAME, FIELD FROM REVIEWER, PERSON WHERE PERSON.EMAIL=REVIEWER.EMAIL",
				     "SELECT EMAIL, REVIEW.PAPERID, TITLE, CONTRIBUTION, RELEVANCE, SIGNIFICANCE, ORIGINALITY, READABILITY, FAMILIARITY FROM REVIEW, PAPER WHERE REVIEW.PAPERID = PAPER.PAPERID",
				     "SELECT CLASH.PAPERID, TITLE, STDDEVIATION FROM PAPER, CLASH WHERE CLASH.PAPERID = PAPER.PAPERID",
				     "SELECT PAPER.PAPERID, TITLE FROM ACCEPTEDPAPER,PAPER WHERE PAPER.PAPERID = ACCEPTEDPAPER.PAPERID",
				     "SELECT * FROM FINALASSIGNMENTS",
				     "SELECT * FROM TENTATIVEASSIGNMENTS",
				     "SELECT * FROM BIDS"
		};
		
		try
		{
			if((queryNo >= 0) && (queryNo <= 2))
			{
			      paperId = removeBlank((String)req.getParameter("paperid"+queryNo));
		      	      if (!paperId.equals(""))
				   if((queryNo == 2) || (queryNo == 1))
				   	queries[queryNo] += " AND PAPERID = \'"+paperId+"\'";
			           else 
				   	queries[queryNo] += " WHERE PAPERID = \'"+paperId+"\'";
		        }
		        con = DB.getConnection();
		        Statement st = con.createStatement();
			ResultSet rs = st.executeQuery(queries[queryNo]);
			ResultSetMetaData rsmd = rs.getMetaData();
			ShowStuff.printHeader("Results of the Query!", out);
			out.println("<body>");
			out.println("<table align=center>");

			int noTuples = 0;
			int colCount = rsmd.getColumnCount();
			int totalRating=0; //valid for only the query that gets the details of a review.
			while(rs.next())
		        {
			      totalRating = 0;
			      if(noTuples == 0)
			      {
				    out.println("<tr>");
				    for(int i=1; i<=colCount; i++)
			       	    out.println("<th>"+rsmd.getColumnName(i)+"</th>");
				    if(queryNo == reviewQueryNo) //the query that gets the details of a review
				          out.println("<th>AVERAGE RATING</th>");
		       		    out.println("</tr>");
			      }
			      out.println("<tr>");
			      for(int i=1; i<=colCount; i++)
			      {
				   out.println("<td>"+rs.getString(i)+"</td>");
				   if((queryNo == reviewQueryNo) && (i >= 4))
				         totalRating += Integer.parseInt((String)rs.getString(i));
			      }
			      if(queryNo == reviewQueryNo)
				    out.println("<td>"+(float)totalRating/(colCount-3)+"</td>");
			      out.println("</tr>");
			      noTuples++;
			}
		        if(noTuples == 0)
			      out.println("<font color=blue> There are no matches </font>");
		        out.println("</table>");
		        out.println("<br><br>");
		        ShowStuff.printFooter(out);
			con.close();
		}
		catch(SQLException sqle){System.out.println(sqle);}
	}
	
	public static String removeBlank(String str) //removes the leading and trailing blank in the string str.
	{
	  	char[] resultArr1 = new char[200];
		int j = 0;
		if (str == null)
		     return("");
		for(int i=0; i < str.length(); i++)
		{
		      if(str.charAt(i) != ' ') {
			     resultArr1[j] = str.charAt(i); 
			     j++;
		      }
		}
		char[] resultArr2 = new char[j];
		if(j==0)
		      return("");
		for(int i=0; i<j; i++)
		      resultArr2[i] = resultArr1[i];	
		return(new String(resultArr2));
	}
}
