import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

import util.*;

/** 
 * This servlet provides an interface to the Admin to make final
 * selections of papers amongst all that were registered. He gets
 * to see total marks given by all reviewers as per the weightages 
 * assigned to the attributes being marked, average marks awarded,
 * Standard deviation amongst the reviews, links to download
 * the reviews submitted and links to details of each paper. 
 * The papers are sorted accoring to the total marks awarded to them
 * with the higher marked papers upper in the form, so as to make selection
 * convinient.
 * After evaluating the paper on each of these parameters, he can 
 * submit his selection in the form provided which puts a checkbox
 * in front of each paper. In case of clash or even otherwise, 
 * Admin can mail the reviewers to resubmit their reviews.
 * Admin can revisit the page to make selection again. He obviously 
 * gets to see the previous selections. 
 *
 * @author Mithun Arora
 * @version 1.00  Mon 13 Nov 2000 23:23:11 IST 2000
 *
 */ 
 
public class SelectPaper extends HttpServlet 
{
	
	/* Initialise the servlet */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	
	/** 
	 * Returns true if the attribute of the review is a configurable
	 * attribute, ie not a compulsary attribute. 
	 * @param attribute String - attribute name that is to be checked.
	 */ 
	private boolean isConfigurable(String attribute)
	{
		return(!((attribute.equalsIgnoreCase("PAPERID")) || 
					(attribute.equalsIgnoreCase("EMAIL")) ||
					(attribute.equalsIgnoreCase("SUMMARYEXTN")) ||
					(attribute.equalsIgnoreCase("COMMENTSTOPCEXTN")) ||
					(attribute.equalsIgnoreCase("COMMENTStoAUTHOREXTN")))); 
	}

   /** 
	 * doGet prints the form to make the final selection of papers.
	 * The papers are presented in sorted order and marked apriori if they were
	 * selected earlier.
	 *
	 * @param req HttpServletRequest
	 * @param res HttpServletResponse
	 */ 
	
	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
		{

			HttpSession session=req.getSession(false);
			res.setContentType("text/html");
			PrintWriter out=res.getWriter();

			/* Check session validity. Only Admin allowed */
			String whoisit=(String)session.getValue("whoami");

			if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
				throw new UnavailableException(this,"Invalid Access Attempt");
			}

			Connection con=null;
			try
			{
				con=DB.getConnection();
				Statement stmt=con.createStatement();
				ResultSet rs=stmt.executeQuery("SELECT * FROM WEIGHTAGE");
				/* Weightage for each attribute and MaxStandardDeviation
				 * are put in the hashtable, and then retrieved when totalling
				 * marks for each table. */
				Hashtable weightage=new Hashtable();
				String param=null, value=null;
				while(rs.next())
				{
					param=rs.getString("ATTRIBUTE");
					value=rs.getString("WEIGHTAGE");
					weightage.put(param.toLowerCase(),value);
				}

				/* A list of accepted papers is maintained in the vector.
				 * When marking the checkbox "CHECKED" or "UNCHECKED" it
				 * is checked if the paper was marked accepted when the last time
				 * Adminn came to make a selection. */
                String query="SELECT PAPERID FROM ACCEPTEDPAPER";
				rs=stmt.executeQuery(query);
				Vector acceptedPapers=new Vector();
				while(rs.next())
				{
					acceptedPapers.addElement(rs.getString("PAPERID"));
				}
			
			 /* The real thing! The reviews of all reviewers for each paper
			  * are taken. The marks are added and extensions to files
			  * corresponding to reviews are stored in Hashtable, later
			  * to be used while giving links to download them. */
			   query="SELECT * FROM REVIEW";
				rs=stmt.executeQuery(query);
				ResultSetMetaData rsmd=rs.getMetaData();
				int numparams=rsmd.getColumnCount();
				String paperId=null;
				/* paperReviews is bigger hashtable mapping a paper to another 
				 * smaller hashtable reviewMarks, which maps each reviewer's
				 * emailId to the total weighted marks he has given to that 
				 * paper. */
				Hashtable paperReviews=new Hashtable(); 
				Hashtable reviewMarks=null;
				/* Stores the Files Extension in form 
				 * paperId:reviewer:CPCExtn ---> extn .etc */
				Hashtable reviewExtn=new Hashtable();
				int totalMarks;
				String currparam=null;

				while(rs.next())
				{
					totalMarks=0; /* total marks for each paper-reviewer pair. */
					paperId=rs.getString("paperId");
					if(!paperReviews.containsKey(paperId))
					{
						reviewMarks=new Hashtable();
					}
					else
					{
						reviewMarks=(Hashtable)paperReviews.get(paperId);
					}
					for(int i=1; i<=numparams; i++)
					{
						currparam=rsmd.getColumnName(i);
						/* Except parameter like fileExtns, emailIds and paperId
						 * rest parameters are assumed to be marks parameters
						 * and are added  like integers. */
						if(isConfigurable(currparam))
						{
							Integer thisMarks=new Integer(rs.getString(currparam));
							Integer thisWeight=new Integer((String)weightage.get(currparam.toLowerCase()));
							totalMarks=totalMarks+(thisMarks.intValue()*thisWeight.intValue());
						}
					}
					String reviewer=rs.getString("email");
					reviewMarks.put(reviewer, totalMarks+"");
					/* Hashtable to store file extensions, in form specified above. */ 
					reviewExtn.put(paperId+":"+reviewer+":"+"CPCExtn", rs.getString("COMMENTSTOPCEXTN"));
					reviewExtn.put(paperId+":"+reviewer+":"+"CAExtn", rs.getString("COMMENTStoAuthorEXTN"));
					reviewExtn.put(paperId+":"+reviewer+":"+"SExtn", rs.getString("SUMMARYEXTN"));

					paperReviews.put(paperId, reviewMarks);
				}

//				ShowStuff.printHeader("Select Papers!",out);
	         out.println("<html><head><title>Select Papers!</title></head>");
				out.println("<body bgcolor=white");
				
				out.println("<p><table width=360 border=0 cellspacing=0 cellpadding=0>");
				out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a></td></tr");
				out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a></td></tr>");
				out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MailServlet\">Send Mail </a></td></tr>");
				out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MailAuthors\">Send Mail to Accepted/Rejected papers</a></td></tr>");
				out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/CreateMailingList\">Create Mailing List</a></td></tr>");
				out.println("</table>");

				ShowStuff.formTag("post", "http://"+Config._HOST+":"+Config._PORT+"/servlet/SelectPaper", out);
				out.println("<table  width=500 border=1 align=left>");
				/* Paper Details is Title, Abstract, Category, Author. 
				 * Review is again a table containing Reviewer Email, totalMarks, and links to downloading review files
				 * Clash Status just a string signifying whether there is a clash.
				 * All Reviews : a link that gives all reviews for this paper.
				 * Accept Status is a checkbox.
				 * */
				out.println("<tr><th>PaperId</th><th>Details</th><th>Review</th><th>All Reviews</th><th>Average Marks</th><th>Standard Deviation</th><th>Clash Status</th><th>Accept Status</th></tr>");
              /* averageMarks for each paper to show along
			   * with individual marks for each reviewer. */
				Hashtable averageMarks=getAverageHash(paperReviews);  
			 /* Sorts the papers according to the averageMarks they got
			  * and the papers are finally shown in this order only, read one
			  * by one from the vector. */
				Vector sortedPapers=getSortedVec(averageMarks);
			 /* Calculates standard deviation amongst reviews. Used to mark
			  * a clash or no clash among the reviews. */
				Hashtable standardDev=getStdDev(paperReviews, averageMarks);
				for (int i=0; i<sortedPapers.size(); i++)
				{
					paperId=(String)sortedPapers.elementAt(i);
					reviewMarks=(Hashtable)paperReviews.get(paperId);
					out.println("<tr><td width=30>"+paperId+"</td>");
					/* Here link to details of this paper */
					out.println("<td width=50><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/QueryParticipant?sqlquery=SELECT%20PAPERID,TITLE,CATEGORY,ABSTRACT%20FROM%20PAPER%20WHERE%20PAPERID="+paperId+"\" >Paper Details</a></td>");
				  /* Individual reviews and links to download files. */	
					out.println("<td width=220><table>");
					Enumeration marksEnum=reviewMarks.keys();
					String reviewer=null;
					while(marksEnum.hasMoreElements())
					{
						reviewer=(String)marksEnum.nextElement();
						out.println("<tr>");
						out.println("<td>"+reviewer+"</td>");
						out.println("<td>"+(String)reviewMarks.get(reviewer)+"</td></tr>");
						out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Download?filename="+Config._REVIEW_REPOSITORY+File.separatorChar+paperId+File.separatorChar+reviewer+File.separatorChar+"CommentsToAuthor."+(String)reviewExtn.get(paperId+":"+reviewer+":"+"CAExtn")+"\">Author</a></td>");
						out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Download?filename="+Config._REVIEW_REPOSITORY+File.separatorChar+paperId+File.separatorChar+reviewer+File.separatorChar+"CommentsToPC."+(String)reviewExtn.get(paperId+":"+reviewer+":"+"CPCExtn")+"\">PC</a></td>");
						out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Download?filename="+Config._REVIEW_REPOSITORY+File.separatorChar+paperId+File.separatorChar+reviewer+File.separatorChar+"Summary."+(String)reviewExtn.get(paperId+":"+reviewer+":"+"SExtn")+"\">Summary</a></td>");
						out.println("</tr>");
					}
					out.println("</table></td>");
					
		  		   out.println("<td width=50><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/QueryParticipant?sqlquery=SELECT%20*%20FROM%20REVIEW%20WHERE%20PAPERID="+paperId+"\" >Review Details</a></td>");

				    String average=(String)averageMarks.get(paperId);
					out.println("<td width=30>"+average+"</td>");

					int stdDev=((Integer)standardDev.get(paperId)).intValue();

					out.println("<td width=30>"+stdDev+"</td>");
					int maxStdDev=(new Integer((String)weightage.get("maxstddev"))).intValue();
					String clashStatus=(stdDev>maxStdDev)? 
						"<font color=red> Clash!</font>":
						"<font color=green> No Clash</font>";
					out.println("<td width=30>"+clashStatus+"</td>");
					if(acceptedPapers.contains(paperId))
					{
					   System.out.println("fine tag");	
						out.println("<td width=80><input type=\"checkbox\" name=\""+paperId+"\" checked>Accept </td>");
					}
					else
						out.println("<td width=80><input type=\"checkbox\" name=\""+paperId+"\">Accept </td>");
					out.println("</tr>");
				}

				out.println("</table>");
				out.println("<br><br><br><br><br><br><br><br><br><br><p>");
				out.println("<br><br><br><br><br><br><br><br><br><br><p>");
				out.println("<input type=\"Submit\" value=\"Accept\">");
				out.println("</form>");

				out.println("</body></html>");
//				ShowStuff.printFooter(out);
				con.close();

			}
			catch (SQLException sqle)
			{
				ShowStuff.throwError("Database Access Error!!", out);
				if(con!=null) {con=null; }
			}
		}

/** 
 * doPost Takes the filled in above form as a request and inserts into database
 * values if they are not already there, also if a paper is already there 
 * in AcceptedPapers table and is marled not accepted in this request
 * it is removed from there.
 *
 * @param req HttpServletRequest
 * @param res HttpServletResponse
 */ 

	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
		{
			HttpSession session=req.getSession(false);
			res.setContentType("text/html");
			PrintWriter out=res.getWriter();

			System.out.println("IN POST!");
			/* Check session validity. Only Admin allowed */
			String whoisit=(String)session.getValue("whoami");

			if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
				throw new UnavailableException(this,"Invalid Access Attempt");
			}

			ShowStuff.printHeader("Select Papers!",out);
			out.println("<p><table width=360 border=0 cellspacing=0 cellpadding=0>");
			out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a></td></tr");
			out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a></td></tr>");
			out.println("</table>");
			
			Enumeration paramnames=req.getParameterNames();
			Connection con=null;
			String currPaper=null;  	
			String accept=null; //this is ON if paper is selected. OFF o/w
			try
			{
				con=DB.getConnection();
				Statement stmt=con.createStatement();
			  /* Put the papers that were already there in AcceptedPaper
			   * in vector. Now while iterating through each paper in request,
			   * it is checked whether it was there in DB and accordingly
			   * inserted or deleted. */
				String query="SELECT PAPERID FROM ACCEPTEDPAPER";
				ResultSet rs=stmt.executeQuery(query);
				Vector acceptedPapers=new Vector();
				while(rs.next())
				{
					acceptedPapers.addElement(rs.getString("PAPERID"));
				}

				String updateCommand=null;
				while(paramnames.hasMoreElements())
				{
					currPaper=(String)paramnames.nextElement();
					accept=req.getParameter(currPaper);

					if(accept!=null && accept.equalsIgnoreCase("ON")
							&& !acceptedPapers.contains(currPaper)) // select this paper
					{
						updateCommand="INSERT INTO ACCEPTEDPAPER VALUES('"+currPaper+"', 'null')";
						stmt.executeUpdate(updateCommand);
					}
					if (accept!=null && !accept.equalsIgnoreCase("ON")
							       && acceptedPapers.contains(currPaper))
					{
						updateCommand="DELETE FROM ACCEPTEDPAPER WHERE PAPERID='"+currPaper+"'";
						stmt.executeUpdate(updateCommand);
					}
				}
				out.println("<br><br>PaperIds are stored appropriately in the Database");
				out.println("<br><br>");

				out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MailAuthors\">here</a> to send Mail to Accepted/Rejected Papers");
				
			}
			catch (SQLException sqle)
			{
				ShowStuff.throwError("Database Access Error!!", out);
				if(con!=null) {con=null; }
			}
			ShowStuff.printFooter(out);
		}


/** Given the hashtable of paper vs average of all reviewers marks awarded
 * to it, this sorts the papers, so that they can be presented in a readable
 * form to Admin, with papers getting more marks shown above and rest below. 
 *
 * @param averageMarks Hashtable
 */ 

	private Vector getSortedVec(Hashtable averageMarks)
	{
		Vector sortedPapers=new Vector();
		Enumeration paperEnum=averageMarks.keys();
		String jpaper=null, ipaper=null;
		String tmpPaper=null;
		int markI, markJ;
		String strMarks=null;
		/* The papers are put in sortedPapers Vecor as they are read. */
		while(paperEnum.hasMoreElements())
		{
			tmpPaper=(String)paperEnum.nextElement();
			sortedPapers.addElement(tmpPaper);
		}

		String largePaper=null;
		int large;
		for(int i=0; i<sortedPapers.size(); i++)
		{
			ipaper=(String)sortedPapers.elementAt(i);
			strMarks=(String)averageMarks.get(ipaper);
			markI=(new Integer(strMarks)).intValue();
			large=markI;
			largePaper=ipaper;
			int index=i;
			for(int j=i+1; j<sortedPapers.size(); j++)
			{
				jpaper=(String)sortedPapers.elementAt(j);
				strMarks=(String)averageMarks.get(jpaper);
				markJ=(new Integer(strMarks)).intValue();
				if(large<markJ)
				{
					index=j;
					large=markJ;
					largePaper=jpaper;
				}
			}

			if(large!=markI)  //swap paper[i] and Paper[large]
			{
				sortedPapers.setElementAt(largePaper, i);
				sortedPapers.setElementAt(ipaper, index);
			}

		}
		return sortedPapers;
	}
 
/** Given hashtable of paper vs (Hashtable of reviewer vs marks awarded by him)
 * it returns a hashtable of paperId vs averageMarks awarded to it
 *
 * @param paperReviews Hashtable
 * @return averageMarks Hashtable
 */
	private Hashtable getAverageHash(Hashtable paperReviews)
	{
		Hashtable averageMarks=new Hashtable();
		Enumeration papers=paperReviews.keys();
		Hashtable reviewMarks=null; 
		int average;
		int total;
		int numRev;
		String paperId=null;
		while(papers.hasMoreElements())
		{
			paperId=(String)papers.nextElement();
			total=0;
			numRev=0;
			reviewMarks=(Hashtable)paperReviews.get(paperId);
			Enumeration reviewEnum=reviewMarks.keys();
			String reviewer=null;
			Integer thisMarks=null;
			while(reviewEnum.hasMoreElements())
			{
				reviewer=(String)reviewEnum.nextElement();
				numRev++;
				thisMarks=new Integer((String)reviewMarks.get(reviewer));
				total+=thisMarks.intValue();
			}
			average=total/numRev;
			averageMarks.put(paperId,""+average);
		}
		return averageMarks;
	}

/** Given all reviews for papers computes the Hashtable of paerId vs Standard
 * Deviation amongst reviews. Standard Dev is used as just a way to mark a clash
 * It can be a more complicated mathematical formula which can be computed
 * in a different way without changing much of rest of the code.
 *
 * @param paperReviews Hashtable
 * @param averageMarks Hashtable
 * @return standardDev Hashtable
 */ 
	private Hashtable getStdDev(Hashtable paperReviews, Hashtable averageMarks)
	{
		Enumeration paperEnum=paperReviews.keys();
		String paperId=null;
		Hashtable reviewMarks=null;
		Hashtable standardDev=new Hashtable();

		while(paperEnum.hasMoreElements())
		{
			paperId=(String)paperEnum.nextElement();
			reviewMarks=(Hashtable)paperReviews.get(paperId);
			Enumeration reviewEnum=reviewMarks.keys();
			int numRev=0;
			int tmpVar;
			int sumSq=0;
			String strAvg=(String)averageMarks.get(paperId);
			int average=(new Integer(strAvg)).intValue();
			int currMark;
			String strCurr=null;
			String currRev=null;
			/* Standard Dev = sqrt( sigma((Xi-Xav)^2)/n) */
			while(reviewEnum.hasMoreElements())
			{
				currRev=(String)reviewEnum.nextElement();
				strCurr=(String)reviewMarks.get(currRev);
				currMark=(new Integer(strCurr)).intValue();
				tmpVar=Math.abs(currMark-average);
				sumSq+=tmpVar*tmpVar;
				numRev++;
			}
			double dSquare=sumSq/numRev;
			double stdDev=Math.sqrt(dSquare);
			int intStdDev=(new Double(stdDev)).intValue();
			standardDev.put(paperId, new Integer(intStdDev));
		}
		return standardDev;
	}
}
