import java.io.*; 
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import util.*;

/** This servlet prompts the Reviewer to submit his review and stores that
 * in the database. The files for Comments to Authors, PC and overall Summary
 * of the Review are stored in the file system in directory 
 * _REVIEW_REPOSITORY/paperId/reviewerID/. We aim to store these reviews 
 * in BLOBs finally.
 *  
 *  @author Mithun Arora
 *  @version 1.00 Mon Oct 10 01:40:41 IST 2000
 *
 */

public class SubmitReview extends HttpServlet
{

	/**  A scale value of 10 means each paper will
	 * be evaluated on each parameter on scale of 0 to 10. */
	private static final int scale=Config._REVIEW_SCALE; 

	/* Initialise the servlet */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	/**  
	 * Generates the review form for the paper. PaperId of paper is read
	 * from request passed. Invalid access to servlet is checked by
	 * reading reviewerId from session. If the review has been submitted
	 * before old scores given for all parameters are displayed for convenience.
	 * @param req HttpServletRequest - request
	 * @param res HttpServletResponse - response to the request
	 */ 


	public void doGet(HttpServletRequest req, HttpServletResponse res) 
		throws ServletException,IOException 
		{
			HttpSession session=req.getSession(false);
			res.setContentType("text/html");
			PrintWriter out=res.getWriter();

			/* Check session validity. Only reviewers allowed */
			String whoisit=(String)session.getValue("whoami");

			if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer"))) ) {
				throw new UnavailableException(this,"Invalid Access Attempt");
			}

			Connection con=null;
			String ID=(String)session.getValue("ID");
			int paperId=Integer.parseInt(req.getParameter("paperId")); /* Reads paperId. */

			try
			{
				/* Open DB connection */
				con=DB.getConnection();

				ShowStuff.printHeader("Welcome!",out);
				out.println("<body>");
				out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a>");
				out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a>");
				out.println("<br><br>");
				out.println("<h2><b>Review for Paper<font color=blue> "+paperId+" </font></b></h2>");

				Statement stmt=con.createStatement();
				ResultSet rs=null;
				String query=null;
				ResultSetMetaData rsmd=null;

				/* Querying from database if the paper has been reviewed before. */
				query="SELECT * FROM REVIEW WHERE (PaperId="+paperId+") AND (email='"+ID+"')";
				rs=stmt.executeQuery(query);
				rsmd=rs.getMetaData();
				int numparams=rsmd.getColumnCount();
				String currparam=null;
				int j=0; /*Initialised to 0. It is incremented if paper has been reviewed before. */

				/* for storing old review if the paper had been reviewed before. */
				Hashtable paramvalues=new Hashtable();

				/* Initialise the configurable (ie the parameters on which scores 
				 * are given) to value in database if they have been reviewed before.*/
				while(rs.next())
				{ 
					j++;  /*j incremented only if paper has been reviewed. */
					for(int i=1; i<=numparams; i++)
					{
						currparam = rsmd.getColumnName(i);
						if(isConfigurable(currparam))
						{
							/* Value read from DB put in hashtable paramvalues. */
							paramvalues.put(currparam, rs.getString(currparam));	
						}
					}
				}
				/* If paper is being reviewed for the first time, the configurable
				 * parameters are intialised to scale/2. */
				if (j==0)
				{
					for(int i=1; i<=numparams; i++)
					{
						currparam = rsmd.getColumnName(i);

						if(isConfigurable(currparam))	
						{
							paramvalues.put(currparam, (new Integer(scale/2).toString()));	
						}
					}
				}


				out.println("<br> Please evaluate the paper on the following parameters.<br><br>");

				/* ENCTYPE="multipart/form-data" is required to support uploading of files. */ 
				out.println("<form name=\"review\"  enctype=\"multipart/form-data\" method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/SubmitReview\">");
				out.println("<table>");

				Enumeration paramnames=paramvalues.keys();
				while(paramnames.hasMoreElements())
				{
					currparam=(String)paramnames.nextElement();
					out.println("<tr><td>"+currparam+"</td>");
					/* All parameter names in the form are in lower case. 
					 * This makes reading them in doPost() more peaceful. */
					out.println("<td><select  name=\""+currparam.toLowerCase()+"\">");
					for(int k=0; k<=scale; k++)
					{
						if (k==Integer.parseInt((String)paramvalues.get(currparam)))
						{	
							out.println("<option selected> "+k);
						}
						else
							out.println("<option> "+k);
					}
					out.println("</select> </td> </tr>");
				}

				out.println("<tr><td> Comments to the Programming Committe</td> ");
				out.println("<td><input type=\"file\" name=\"commentstopc\"> </td> </tr>");
				out.println("<tr><td> Comments to the Author</td> ");
				out.println("<td><input type=\"file\" name=\"commentstoauthor\"> </td></tr>");
				out.println("<tr> <td>Summary of the Review </td> ");
				out.println("<td> <input type=\"file\" name=\"summary\"> </td></tr><br>");
				out.println("</table><br>");

				out.println("<input type=\"hidden\" name=\"paperId\" value=\""+paperId+"\">");
				out.println("<input type=\"Submit\" value=\"Submit\">");
				out.println("</form>");
				ShowStuff.printFooter(out);
				con.close();
			}
			catch(SQLException sqle)
			{ 
				ShowStuff.throwError("Database Access Error!!", out);
				if(con!=null) {con=null; }
			}
		}



	/** 
	 * Returns true if the attribute of the review is a configurable
	 * attribute, ie not a compulsary attribute. 
	 * @param attribute String - attribute name that is to be checked.
	 */ 

	private boolean isConfigurable(String attribute)
	{
		return(!((attribute.equalsIgnoreCase("PAPERID")) || 
					(attribute.equalsIgnoreCase("EMAIL")) ||
					(attribute.equalsIgnoreCase("SUMMARYEXTN")) ||
					(attribute.equalsIgnoreCase("COMMENTSTOPCEXTN")) ||
					(attribute.equalsIgnoreCase("COMMENTStoAUTHOREXTN")))); 
	}

	/**
	 * This function copies file fsrc to file specified by String fdest. 
	 * It returns false if copying the file is not possible, else returns true. 
	 * @param fsrc   File  - Source File
	 * @param fdest  String -  Pathname of destination file.
	 */
	private boolean fileCopy(File fsrc, String fdest)
	{
		try
		{
			FileInputStream instr=new FileInputStream(fsrc);
			FileOutputStream outstr=new FileOutputStream(new File(fdest));
			int b1=instr.read();
			while(b1!=-1)
			{
				outstr.write(b1);
				b1=instr.read();
			}
		} 
		catch (IOException ioe) 
		{
			return false;
		}
		return true;
	}

	/** 
	 * This function returns the extension in a filename. 
	 * The extension is the string after the last "." in filename.
	 * If there is no extension in the string txt is returned. 
	 * @param filename String
	 */
	private String getExtension(String filename)
	{
		StringTokenizer strtok= new StringTokenizer(filename, ".");
		String extn="txt"; //txt is the default extension
		String toks=null, toks1=null;
		toks1=strtok.nextToken();
		while(strtok.hasMoreElements())
		{
			toks=strtok.nextToken();
		}
		if (toks!=null)
			extn=toks;
		return extn;
	}

	/** 
	 * Enters the inputted values in the review in the Database. 
	 * Files uploaded are stored in directory _REVIEW_REPOSITORY/paperId/ReviewerEmail/Summary|CommentsToAuthor|CommentsToPC.
	 * Extensions to the files are stored in the database.
	 * A review is not accepted unless all files corresponding to a complete
	 * review are uploaded. 
	 * Note: Class MultipartRequest from package com.oreilly.servlet is used for uploading of files.
	 * @param req HttpServletRequest 
	 * @param res HttpServletResponse
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException 
	{
		HttpSession session=req.getSession(false);
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();

     /* Generates a MultipartRequest initialised with present HttpServletRequest,
		* Directory in which to store the reviews and maximum size of any review 
		* The last 2 parameters are read from Config file. */
		MultipartRequest multi = new MultipartRequest(req, Config._REVIEW_REPOSITORY, Config._MAX_REVIEW_SIZE);
		
		/* Check session validity. Only reviewers allowed */
		String whoisit=(String)session.getValue("whoami");

		if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer"))) ) {
			throw new UnavailableException(this,"Invalid Access Attempt");
		}
		
		Connection con=null;
		String ID=(String)session.getValue("ID");
		int paperId=Integer.parseInt(multi.getParameter("paperId"));

		try
		{
			con=DB.getConnection();
			ShowStuff.printHeader("Welcome!",out);
			out.println("<body>");
			out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a>");
			out.println("<a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a>");
			out.println("<br><br>");
			Statement stmt=con.createStatement();
			String query="SELECT * FROM REVIEW WHERE email='"+ID+"' and PAPERID='"+paperId+"'"; 
			ResultSet rs=stmt.executeQuery(query);
			ResultSetMetaData rsmd=rs.getMetaData();
			int numresults=0;
			
			/* these are updated to the actual extension of stored file if the 
			 * paper has been reviewed before. In that case they are read from DB.
			 * Else they are updated when files for Review are being stored. 
			 * If anyone of these remains null even after that, then file
			 * has not been uploaded properly. In that case review is not accepted.*/
			String comauthExtn=null;
			String compcExtn=null;
			String summaryExtn=null;
		
			/* numresults is incremented to 1 if paper has been reviewed before.
			 * In that case first the previous entry has to be deleted from the database,
			 * and then only new entry added, else Integrity constraints of 
			 * Data are violated. */
			while(rs.next())
			{
				comauthExtn=rs.getString("CommentsToAuthorExtn");
				compcExtn=rs.getString("CommentsToPcExtn");
				summaryExtn=rs.getString("SummaryExtn");
				numresults++;
			}  
		
			/* Preparing the query for inserting row corresponing to the new review. */
			int numparams=rsmd.getColumnCount();
			String insertparams="(email, paperId ";
			String insertvals="('"+ID+"', '"+paperId+"'";
			boolean error=false; /*Made true at any stage where an error in review is detected. */
			int paramval;
			for(int i=1; i<=numparams; i++)
			{
				String currparam=rsmd.getColumnName(i);
				if(isConfigurable(currparam))
				{
					paramval= Integer.parseInt(multi.getParameter(currparam.toLowerCase()));
					insertparams+=", "+currparam;
					insertvals+=", '"+paramval+"'";
				}
			}

			/* Uploading review files and checking if all of them are
			 * uploaded. Using com.oreilly.servlet.MultipartRequest class.
			 */

			/* If the extension of any one file doesnt exist in the DB, that
			 * means that the directory corresponding to that review is not 
			 * created. So we get the directory corresponding to that review,
			 * by either creating it, or getting the name of the Dir. */

			File reviewDir =new File(Config._REVIEW_REPOSITORY+File.separatorChar+paperId+File.separatorChar+ID);
			if (!reviewDir.exists())  
			{
				reviewDir.mkdirs();
			}
         
			/* The file is stored in directory _REVIEW_REPOSITORY by the
			 * MultiRequest class by name same as the user file. We need 
			 * to store the file in a predefined name. So a copy of file
			 * is made with the name we want it to be. In the end file
			 * in _REVIEW_REPOSITORY is deleted.Simply renaming of file
			 * will not work here, as same file can be uploaded as 
			 * CommentsToPC and Summary. So if renamed, only one of the above
			 * can be stored. */
			File comauth = multi.getFile("commentstoauthor");
			if(comauth!=null)
			{

				comauthExtn=getExtension(comauth.getName());
				error= !fileCopy(comauth, reviewDir.getAbsolutePath()+File.separatorChar+"CommentsToAuthor."+comauthExtn);
			}

			insertvals+=", '"+comauthExtn +"'";

			insertparams+=", CommentsToAuthorExtn";

			File compc = multi.getFile("commentstopc");
			if(compc!=null)
			{
				compcExtn=getExtension(compc.getName());
				error=!fileCopy(compc, reviewDir.getAbsolutePath()+File.separatorChar+"CommentsToPC."+compcExtn);
			}
			insertvals+=", '"+compcExtn +"'";
			insertparams+=", CommentsToPCExtn";

			File summary = multi.getFile("summary");
			if(summary!=null)
			{
				summaryExtn=getExtension(summary.getName());
				error=!fileCopy(summary, reviewDir.getAbsolutePath()+File.separatorChar+"Summary."+summaryExtn);
			   System.out.println( reviewDir.getAbsolutePath()+File.separatorChar+"Summary."+summaryExtn);

			}
			insertvals+=", '"+summaryExtn +"'";
			insertparams+=", SummaryExtn";

			/* Any of these being null means that a complete review is not uploaded
			 * or was not available apriori. */
			if((compcExtn==null)||(comauthExtn==null)||(summaryExtn==null))
			{

				error=true;
				ShowStuff.throwError("Error!", "Kindly upload all reviews!", out);
			}

			insertparams+=")";
			insertvals+=")";

			/* In the rare case ;-) that Reviewer manages to get through all 
			 * security checks, his reviews are finally stored in the DB. */
			
			if(!error)
			{
				if (numresults==1)
				{
					stmt.executeUpdate("DELETE FROM REVIEW WHERE EMAIL='"+ID+"' AND PAPERID='"+paperId+"'");
				}  //deleting the prev value of review...

				/* Temporary files in _REVIEW_REPOSITORY have to be deleted. */
				if(summary!=null)
					summary.delete();
				if(compc!=null)	
					compc.delete();
				if(comauth!=null)	
					comauth.delete();
			
				/* Finally....*/
				stmt.executeUpdate("INSERT INTO REVIEW "+insertparams +" values " +insertvals);
				out.println("Your review has been successfully accepted. Thank you");
				out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit)+"\">here</a> to go to your main page.<br><hr size=1>");
			}
			else //in case of error files already stored have to be deleted.
			{
				if((summary!=null) && (summary.exists()))
					summary.delete();
				if((compc!=null)	&& (compc.exists()))
					compc.delete();
				if((comauth!=null) && (comauth.exists()))	
					comauth.delete();
				
				File summary1=new File(reviewDir.getAbsolutePath()+File.separatorChar+"Summary."+summaryExtn);
				if(summary1.exists())
					summary1.delete();
				File compc1=new File(reviewDir.getAbsolutePath()+File.separatorChar+"CommentsToPC."+compcExtn);
				if(compc1.exists())
					compc1.delete();
				File comauth1=new File(reviewDir.getAbsolutePath()+File.separatorChar+"CommentsToAuthor."+comauthExtn);
				if(comauth1.exists())
					comauth1.delete();

			}

					ShowStuff.printFooter(out);
				con.close();
			}
			catch(SQLException sqle)
		{
			ShowStuff.throwError("Database Access Error.", out);
			if (con!=null) {con=null; }
		}

	}
}

