import java.io.*;
import java.util.*;
import java.net.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** This servlet shows Tentative Assignments on the browser window and 
 *  starts an applet in another window. 
 */
public class Tentative extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** Does all the work 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Checking that the user is Admin only */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");   /* Id of the user */

		  Connection con=null;

		  try {
			   /* Open a DB Connection */
			   con=DB.getConnection();
			   Statement st=con.createStatement();
			   ResultSet rs=st.executeQuery("SELECT * FROM TENTATIVEASSIGNMENTS");
               /* Check is this is being done for the first time */  
			   if (rs.next()) {  /* no */
					out.println("<html><head><title>Tentative Assignments</title>");
					out.println("<script language=\"Javascript\"> ");
					out.println("function winOpen(url) { msg=open(url, \"DisplayWindow\", \" toolbar=yes, directories=no, menubar=yes, status=yes \"); }");
					out.println("</script>") ;
					out.println("</head>");
					out.println(" ");

					// The fol is in general case.....
					//		   out.println("<body bgcolor=white onLoad=\"winOpen('http://"+Config._HTMLROOT+"servlets/AssignApplet.html')\">");
					//and the fol is for everest....	//HARDCODED 'coz of that applet-servlet problem	   
					out.println("<body bgcolor=\"white\" onLoad=\"winOpen('http://everest.cse.iitb.ernet.in/~aameek/dbp/html/AssignApplet.html')\">");
					out.println("<font size=4 color=blue>Tentative Assignments</font><br><br>");

					out.println("<table>");
					out.println("<tr><td>"+rs.getString(1)+"</td><td>"+rs.getString(2)+"</td></tr>");
					while (rs.next()) {
						 out.println("<tr><td>"+rs.getString(1)+"</td><td>"+rs.getString(2)+"</td></tr>");
					}
					out.println("</table>");


					out.println("</body>");
					out.println("</html>");
			   } else {  /* yes. So first calculate Tentative Assignments */
					AssignReviewers obj=new AssignReviewers();
					obj.assignPapers();
					res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
					res.setHeader("Location","http://"+Config._HOST+":"+Config._PORT+"/servlet/Tentative");

			   }
		  } catch (Exception e) { 
			   e.printStackTrace();
			   ShowStuff.throwError("Error",out); 
			   if (con != null) con=null;
		  }

	 }
}
