package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class accepts an eventid from AdminViewEvent Servlet and 
 * throws out the corresp event details. It also allows changes to the 
 * event details...
 *
 * @author B. Aditya
 * @version 1.00 Tue Oct 10 22:14:54 IST 2000
 */
public class AdminGetEventDetailsServlet extends HttpServlet {
	/**
	 * doPost - gets an eventid from AdminViewEvents servlet and 
	 * posts the appropriate data on screen as textboxes. 
	 * 
	 * @param request HttpRequest
	 * @param response HttpResponse
	 *
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
		 throws ServletException, IOException {
		HttpSession session;
		PrintWriter pw;
		String userid,eventid;
		EMSpecData ems; 

		pw = response.getWriter();
		response.setContentType("text/html");
		session = request.getSession(false);

		if (session == null) {
		 	HtmlGen.writeHeader("Session Error",pw);
		 	pw.println("<h1> There was an error processing your session");
		 	HtmlGen.writeFooter("","","","",pw);
		} else {
			userid = (session.getValue("userid")).toString();
			if (userid.equals("sysad")) {
				eventid = request.getParameter("eventid");
			 	if (eventid == null /*|| eventid is not valid*/) {
					HtmlGen.writeHeader("Error",pw);
					pw.println("<h1>You haven't selected any event to view. Please do so.</h1>");
					pw.println("<center> Click <a href="+sat.Config.hostname+":"+sat.Config.port+"/serlvet/ave> here </a> to view event list");
					HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout","","",pw);
				} else {
					// throw out page
					ems = sat.SharedObjects.qe.getEventDetails(eventid);
					
					HtmlGen.writeHeader("Event Details",pw);
					pw.println("<h1>Event details for " + ems.name + "</h1><hr>");
					 
					//pw.println("<form name=" + eventid + "_change action=\"" + sat.Config.hostname + ":" + sat.Config.port + "/servlet/aecc\" method=POST>");
					// call the admin event capacity change servlet
					
					pw.println("<table align=center width=40% frame=null border=0>");
					pw.println("<tr><td>Event Id:</td><td>"+ eventid + "</td></tr>");
					pw.println("<tr><td>Location:</td><td>"+ ems.location + "</td></tr>");
					pw.println("<tr><td>Start Date(yyyy-mm-dd):</td><td>"+ ems.startDate + "</td></tr>");
					pw.println("<tr><td>End Date(yyyy-mm-dd):</td><td>"+ ems.endDate + "</td></tr>");
					pw.println("<tr><td>Capacity:</td><td>"+ems.capacity+"</td></tr>");
					pw.println("<tr><td>Individual Event ? :</td>");
					if (ems.IC_flag == 1)
						 pw.println("<td>NO - Contingent event</td></tr>");
					else
						 pw.println("<td>YES</td></tr>");
					
					pw.println("<tr><td>Moderated ? :</td>");
					if (ems.moderated_flag==1)
						 pw.println("<td>YES</td></tr>");
					else
						 pw.println("<td>NO</td></tr>");
					
					pw.println("</table>");
								  
					HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/ave","Back to event list",sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc", "Back to Control Page",pw);
				}
			} else {
				HtmlGen.writeHeader("Access Error",pw);
				pw.println("<h1> You are not authorised to access this page.Go away </h1>");
				HtmlGen.writeFooter("","","","",pw);
			}
		}
	}
}
