package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class provides the frontend for the sysad to remove an event from a database.
 * It inputs the eventid and the eventname and removes all tuples in the db corresponding
 * to it
 *
 * @author B. Aditya
 * @version 1.00 Sat Oct 14 04:35:29 IST 2000
 */
public class AdminRemoveEventServlet extends HttpServlet {
/*
	 /**
	  * The <code>doGet</code> method accepts the eventid, cross checks it and then deletes.
	  *
	  * @param req HttpRequest
	  * @param res HttpResponse
	  *
	  */
/*
	  public void doGet(HttpServletRequest req,HttpServletResponse res) 
		   throws ServletException, IOException {
				
				HttpSession session;
				PrintWriter pw;
				String userid;
				
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 if (userid.equals("sysad")) {
						  HtmlGen.writeHeader("Delete event",pw);
						  pw.println("<h1> Delete event - Enter event-id and name </h1>");
						  pw.println("<hr> <form name=deletevent action="+hp+"/servlet/are method=POST>");
						  pw.println("<table align=center cols=2 width=40% cellpadding=2 cellspacing=2 border=0>");
						  pw.println("<tr><td>Event-id: <input type=text name=eventid length=20></td></tr>");
						  pw.println("<tr><td>Event Name: <input type=text name=eventname length=20></td></tr>");
						  pw.println("<tr><td><input type=submit value=Delete></td><td><input type=reset value=Reset></td></tr>");
						  pw.println("</table>");
						  HtmlGen.writeFooter(hp+"/servlet/rtoc","Back to Control",hp+"/servlet/logout","Logout",pw);
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
		   }
*/
	  /**
	   * <code>doPost</code> takes the names sent in by the doGet method and causes a delete on the db.
	   * 
	   * @param req HttpRequest
	   * @param res HttpResponse
	   *
	   */
	  public void doPost(HttpServletRequest req, HttpServletResponse res) 
		   throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String eventname;
				String eventid;
				boolean success;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);
				String hp = sat.Config.hostname+":"+sat.Config.port;

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 if (userid.equals("sysad")) {
						  eventid = req.getParameter("eventid");
						  //eventname = req.getParameter("eventname");

						  success =  sat.SharedObjects.qe.deleteEvent(eventid);

						  if (success) {
							   HtmlGen.writeHeader("Delete complete",pw);
							   pw.println("<h1> Delete completed </h1>");
							   pw.println("<p>The delete you requested has been completed");
							   HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control",hp+"/servlet/logout","Logout",pw);
						  }
						  else {
							   HtmlGen.writeHeader("Delete incomplete",pw);
							   pw.println("<h1> Delete not completed </h1>");
							   pw.println("<p>The delete you requested could not be completed");
							   HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control",hp+"/servlet/logout","Logout",pw);
						  }
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
		   }
}
				
