package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class, on a doGet displays all the events currently in the database
 * and then allows the sysad to view event details of any event.
 *
 * @author B. Aditya
 * @version 1.00 Tue Oct 10 21:29:14 IST 2000
 */
public class AdminViewEventsServlet extends HttpServlet
{
	 /**
	  * The doGet function checks if the session is ok and the user is indeed a sysad.
	  * If so, it displays a list of events currently in the database, with links going
	  * off from each of them - which show a particular event's complete details.
	  *
	  * @param request HttpServletRequest
	  * @param response HttpServletResponse
	  */
	 public void doGet(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   HttpSession session;
			   String userid,eventname,eventid;
			   ResultSet eventlist;
			   PrintWriter pw;

			   pw = response.getWriter();
			   session = request.getSession(false);
			   response.setContentType("text/html");
			   String hp = sat.Config.hostname+":"+sat.Config.port;

			   if (session==null)
			   {
					HtmlGen.writeHeader("Session Error",pw);
					pw.println("<h1> An error was encountered while processing session </h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					userid = (session.getValue("userid")).toString();
					if (userid.equals("sysad"))
					{
						 HtmlGen.writeHeader("Event List",pw);
						 eventlist = sat.SharedObjects.qe.getEvents();
						 // display
						 pw.println("<h1> Complete list of events. Click on any one for details</h1>");
						 pw.println("<hr><table align=center cols=2 width=50% frame=null border=0 cellspacing=3 cellpadding=3>");
						 pw.println("<th>Event List</th>");
						 try {
							 while (eventlist.next()) {
								  eventid = eventlist.getString(1);
								  eventname = eventlist.getString(2);
								  pw.println("<tr><td><a href="+hp+"/servlet/aged?eventid="+eventid+">"+eventname+"</td>");
								  pw.println("<td><form action="+hp+"/servlet/are method=POST><input type=hidden name=eventid value=\""+eventid+"\"><input type=submit value=Delete></form></tr>");
							 }
						 }catch (SQLException sqle)
						 {
							  System.err.println("SQLException caught while accessing eventlist" + sqle);
						 }
						 pw.println("</TABLE>");
						 HtmlGen.writeFooter(hp+"/servlet/rtoc","Back to Control Page",hp+"/servlet/logout","Logout",pw);
					}
					else
					{
						 HtmlGen.writeHeader("Access Error",pw);
						 pw.println("<h1> You are not authorised to access this page. Go away");
						 HtmlGen.writeFooter("","","","",pw);
					}
			   }
			   pw.close();
		  }
}
