package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This class implements a HttpServlet for changing the user password
 *
 * @author		Tejas Iyer
 * @version		1.00, Tue Sep 26 23:42:49 IST 2000
 */

public class ChangePasswordServlet extends HttpServlet {
	/**
	 * Init method of the servlet
	 */
	public void init() {
	}
	
	/**
	 * Processes all get requests and prints a form for submission
	 * of userid and passwords
	 * Passwords shall be changed only by a post method
	 * @param	req	the HttpServletRequest sent by the form/page
	 * @param	res	the HttpServletResponse contains the response for the request
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		PrintWriter pw;

		res.setContentType("text/html");
		pw = res.getWriter();
		HttpSession session = req.getSession(true);
		pw.println("Event id is " + session.getValue("eventid"));
		
		HtmlGen.writeHeader("Change Password", pw);
		pw.println("<HR>");
		pw.println("<CENTER>");
		pw.println("<FORM ACTION=" + req.getRequestURI() + " METHOD=POST>");
		pw.println("<TABLE BORDER=0 CELLSPACING=3 CELLPADDING=3>");
		pw.println("<TR><TD>");
		pw.println("User-Id: </TD><TD>");
		pw.println("<INPUT TYPE=text NAME=userid SIZE=20>");
		pw.println("</TD></TR>");
		pw.println("<TR><TD>");
		pw.println("Password: </TD><TD>");
		pw.println("<INPUT TYPE=password NAME=oldpasswd SIZE=20>");
		pw.println("</TD></TR>");
		pw.println("<TR><TD>");
		pw.println("New Password: </TD><TD>");
		pw.println("<INPUT TYPE=password NAME=newpasswd SIZE=20>");
		pw.println("</TD></TR>");
		pw.println("<TR><TD>");
		pw.println("<CENTER><INPUT TYPE=submit NAME=submit VALUE=\"Go!\"></CENTER>");
		pw.println("</TD><TD>");
		pw.println("<CENTER><INPUT TYPE=reset NAME=reset VALUE=Clear></CENTER>");
		pw.println("</TD></TR></TABLE>");
		pw.println("</FORM></CENTER>");
		pw.println("<HR>");
		HtmlGen.writeFooter(sat.Config.hostname + ":" + sat.Config.port +"/servlet/rtoc", "Back to Control Page", "", "", pw);

		pw.close();
	}

	/**
	 * Communicates with the Authenticator to verify the password
	 * and then proceeds to change it.
	 * @param	req	the HttpServletRequest which generated the post
	 * @param	res	the HttpServletResponse contains the response for the request
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		 PrintWriter pw;
		 String eventid,userid, oldpasswd, newpasswd, storedpasswd, storeduserid;
		 pw = res.getWriter();
		 res.setContentType("text/html");

		 HttpSession session = req.getSession(false);
		 if (session!=null)
		 {
			  eventid = (session.getValue("eventid")).toString();
			  storeduserid = (session.getValue("userid")).toString();
			  storedpasswd = sat.SharedObjects.qe.getPassword(storeduserid);
			  userid = req.getParameter("userid");
			  oldpasswd = req.getParameter("oldpasswd");
			  newpasswd = req.getParameter("newpasswd");
			  

			  if ((userid == null) || (oldpasswd == null) || (newpasswd == null)) {

				   HtmlGen.writeHeader("Invalid Post",pw);
				   pw.println("<h1>Invalid Post Operation. </h1>");
				   pw.println("<p> The data you entered was not complete.");
				   session.putValue("passwd",storedpasswd);
				   session.putValue("userid",storeduserid);
				   if (eventid.equals("sysad"))
						HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/als", "Back to Control page", sat.Config.hostname+":"+sat.Config.port+"/servlet/cps", "Try Again", pw);
				   else
						HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/login", "Back to Control Page", sat.Config.hostname+":"+sat.Config.port+"/servlet/cps", "Try Again", pw);
				   
				   pw.close();
				   return;
			  }

			  if (sat.SharedObjects.au.checkPassword(userid, oldpasswd,eventid)) {
				   if (newpasswd.equals(""))
				   {
						HtmlGen.writeHeader("Password Change - Use your brains",pw);
						pw.println("<h1> Password Change ineffective </h1>");
						pw.println("<hr><br><br><br><center><p>YOu must enter a non-empty new password.");
						pw.println("You dont want your security compromised, do you ?!");
						session.putValue("passwd",storedpasswd);
				   }		
				   else
				   {
						sat.SharedObjects.au.changePassword(userid, eventid, oldpasswd, newpasswd);
						// now the passwd is changed. Close this session and start a new session.
						HtmlGen.writeHeader("Password Changed", pw);
						pw.println("<h1>Password Change Successful</h1>");
						pw.println("<br><br><br><hr><CENTER>");
						pw.println("Your password has been successfully changed !");
						pw.println("</CENTER>");
						session.putValue("passwd",newpasswd);
				   }
				   session.putValue("userid",userid);
				   if (eventid.equals("sysad"))
						HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/als", "Back to Control page", sat.Config.hostname+":"+sat.Config.port+"/servlet/cps","Change Again", pw);
				   else
						HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/login", "Back to Control Page", sat.Config.hostname+":"+sat.Config.port+"/servlet/cps","Change Again", pw);
				   pw.close();
				   return;
			  } else {
				   HtmlGen.writeHeader("Invalid Password", pw);

				   pw.println("<CENTER>");
				   pw.println("Please check your user-id and password !");
				   pw.println("</CENTER>");
				   session.putValue("passwd",storedpasswd);
				   session.putValue("userid",storeduserid);
				   if (eventid.equals("sysad"))
						HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/als", "Back to Control page", sat.Config.hostname+":"+sat.Config.port+"/servlet/cps", "Try Again", pw);
				   else
						HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/login", "Back to Control Page", sat.Config.hostname+":"+sat.Config.port+"/servlet/cps", "Try Again", pw);

			  }

		 }
		 else
		 {
			  HtmlGen.writeHeader("Bad bad",pw);
			  pw.println("<br><br><h1> You are a bad boy </h1>");
			  pw.println("<hr><p> You cant change password without logging in. You sit here. </p>");
			  HtmlGen.writeFooter("","","","",pw);
		 }
		 pw.close();

	}
}
