package sat;
import java.util.*;

/**
 * this class serves as a wrapper class for all data about a Contingent.
 * It has basic attributes like name, email, cl_name etc and
 * also has a <code>Vector</code> of SubEvent with info on whether 
 * a Team within the Contingent participates in the SubEvent or not.
 *
 * @author Satyen Kale
 * @version 1.00, 21/10/2K
 */

public class ContData {
	/** name */
	public String name;

	/** email */
	public String email;

	/** cl_name */
	public String cl_name;

	/** subevents */
	public Vector se;

	/** team name - for each subevent. null if no partcipation for
	 * the subevent */
	public Vector team_name;
	
	/** subevent ID's */
	public Vector sid;

	/** EMSpecPVals */
	public Vector attrib_vals;
	
	/**
	 * a constructor
	 */
	public ContData() {
		se = new Vector(10, 10);
		team_name = new Vector(10, 10);
		sid = new Vector(10, 10);
		attrib_vals = new Vector(10, 10);
	}

	/**
	 * inserts a SubEvent name into the vectors.
	 *
	 * @param name the name of the SubEvent
	 * @param SEID the ID of the SubEvent
	 * @param tn the team name for this SubEvent, null if no participation
	 */
	public void insertSE(String name, String SEID, String tn) {
		se.addElement(name);
		sid.addElement(SEID);
		team_name.addElement(tn);
	}
	
	/**
	 * inserts EM spec attrib-values.
	 *
	 * @param name the name of the attrib.
	 * @param val the value of the attrib.
	 */
	public void insertEMSpecPVals(String name, String val) {
		attrib_vals.addElement(new String(name));
		attrib_vals.addElement(new String(val));
	}
}
