package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * Event Manager Interface - Part 2
 * Is invoked only when Event manager logs in for the first time.
 * Accepts date from him and inserts into database. Also throws out another 
 * page for more details. Can only be called thro doPost
 *
 * @author B. Aditya
 * @version 1.00  Tue Oct  3 15:36:59 IST 2000
 */

public class EMOneServlet extends HttpServlet {
	 public void init()
	 {
	 }

	 /**
	  * On post from event manager interface, takes all event attribs
	  * and enters in db. Also throws next set of attribs.
	  *
	  * @param request HttpServletRequest
	  * @param response HttpServletResponse
	  *
	  */
	 public void doPost(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   PrintWriter pw;
			   String userid,eventid,location,startDate,endDate,ic,mod;
			   int capacity;
			   HttpSession session;
		       EMSpecData ems;
			   ems = new sat.EMSpecData();

			   response.setContentType("text/html");
			   pw = response.getWriter();
			   session = request.getSession(false);
			   String hp = sat.Config.hostname+":"+sat.Config.port;
			   
			   if (session==null)
			   {
					HtmlGen.writeHeader("Error.",pw);
					pw.println("<h1>Error encountered while processing session.</h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					boolean check=true;
					eventid = (session.getValue("eventid")).toString();
					userid = (session.getValue("userid")).toString();
					
					location = request.getParameter("location");
					startDate = request.getParameter("startDate");
					endDate = request.getParameter("endDate");
					//capacity= request.getParameter("capacity");
					capacity = sat.SharedObjects.qe.getCapacity(eventid);
					ic = request.getParameter("IC_flag");
					mod = request.getParameter("moderated_flag");
					
					ems.name=sat.SharedObjects.qe.getEventName(eventid);
					ems.location=location;
					ems.setDates(startDate,endDate);
					
					ems.capacity=capacity;
					if (ic == null) // question asked is individual?
						 ems.IC_flag = 1; // team based event
					else
						 ems.IC_flag = 0; // individual event
					// team based = 1, individual = 0
					if (mod == null) // question asked is moderated?
						 ems.moderated_flag = 0; // unmoderated
					else
						 ems.moderated_flag = 1; // moderated

					check = sat.SharedObjects.qe.insertEventDetails(eventid, ems);
					
					if (check)
					{
						 // now throw out a form to take in 10 subevent attribs and 
						 // 5 participant attribs (along with moderated flag and who fills
						 // in)
						 HtmlGen.writeHeader("Sub-event and Participant attribs",pw);
						 pw.println("<h1> Enter upto 10 sub-event attributes you would like.</h1>");
						 pw.println("<p> Also please check the appropriate box about who fills what!");
						 pw.println("<hr>");
						 pw.println("<form name=emsa action="+sat.Config.hostname+":"+sat.Config.port+"/servlet/emtwo  method=post>");
						 pw.println("<table align=center width=80% cols=2 frame=null border=0 cellspacing=3 cellpadding=3>");
						 pw.println("<th>Attribute Name</th><th> Mandatory? </th>");
						 pw.println("<tbody>");
						 for (int i=0;i<=9;i++)
						 {
							  pw.println("<tr><td><input type=text name=seattrib"+i+" value=\"\"></td>");
							  pw.println("<td><input type=checkbox name=seismand"+i+"></td></tr>");
						 }
						 pw.println("</tbody></table>");
						 
						 pw.println("<hr><h1> Enter upto 5 participant attributes </h1>");
						 pw.println("<p>Also please check the appropriate box about who fills what!");
						 pw.println("<form name=emspa action="+sat.Config.hostname+":"+sat.Config.port+"/servlet/emtwo  method=post>");
						 pw.println("<table align=center width=80% cols=2 frame=null border=0 cellspacing=3 cellpadding=3>");
						 pw.println("<th>Attribute Name</th><th> Mandatory? </th>");
						 pw.println("<tbody>");
						 for (int i=0;i<=4;i++)
						 {
							  pw.println("<tr><td><input type=text name=pattrib"+i+" value=\"\"></td>");
						      //pw.println("<td><input type=checkbox name=pwhoenters"+i+" value=sem></td>");
							  pw.println("<td><input type=checkbox name=pismand"+i+"></td></tr>");
						 }
						 pw.println("</tbody></table>");
						 pw.println("<hr>");
						 pw.println("<center><input type=submit name=submit value=Go> <input type=reset name=reset value=Clear>");
						 pw.println("</form>");
						 
						 HtmlGen.writeFooter("","","","",pw);
					}
					else
					{
						 // go and take in details again.
						 // 
						 HtmlGen.writeHeader("Event Data - Reinsert " + eventid,pw);
						 pw.println("<h1> Error in insertion - Reinsert </h1>");
						 pw.println("<form name="+eventid+"_params action=\""+sat.Config.hostname+":"+sat.Config.port+"/servlet/emone\" method=POST>");
						 pw.println("<table align=center width=40% frame=null border=0>");
						 pw.println("<tr><td>Location:</td><td><input type=text name=location size=20></td></tr>");
						 pw.println("<tr><td>Start Date:</td><td><input type=text name=startDate size=20></td></tr>");
						 pw.println("<tr><td>End Date:</td><td><input type=text name=endDate size=20></td></tr>");
						 pw.println("<tr><td>Capacity:</td><td>"+sat.SharedObjects.qe.getCapacity(eventid)+"(as set by Administrator)</td></tr>");
						 //pw.println("<tr><td>Capacity:</td><td>"+1000+"(as set by Administrator)</td></tr>");
						 pw.println("<tr><td>Individual Event? :</td><td><input type=checkbox name=IC_flag></td></tr>");
						 pw.println("<tr><td>Moderated? :</td><td><input type=checkbox name=moderated_flag></td></tr>");
						 pw.println("<tr><td><input type=submit value=Submit></td><td><input type=reset value=Reset></td></tr>");
						 pw.println("</table></form>");
						 HtmlGen.writeFooter(hp + "/servlet/logout","Logout now. Enter details later","","",pw);
					}
					pw.close();
			   }
		  }
}
