package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This servlet throws out a list of contingents/individuals who wish to register and
 * are awaiting approval and accepts approval affirmation from the EM.
 *
 * @author B.Aditya
 * @version 1.00 Sun Oct 29 22:29:24 IST 2000
 */

public class EMPendingServlet extends HttpServlet {
	 /**
	  * <code>doGet</code> gets a list of pending participants and displays all details
	  * to the SEM and allows flo to approve/reject.
	  *
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String userid;
			   int usertype;
			   Vector v;
			   Enumeration e;
			   String arr1,arr2;
			   String name;
			   String loginid;
			   String hp = sat.Config.hostname +":"+sat.Config.port;
			   int count=0;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));

					if (usertype!=0){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h1>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 // now get results and display
						 if (sat.SharedObjects.val.isModerated(eventid)) {
							  v = sat.SharedObjects.qe.getPending(eventid);

							  if (v==null) {
								   HtmlGen.writeHeader("No pending",pw);
								   pw.println("<h1> No pending participants</h1><hr>");
								   HtmlGen.writeFooter(hp+"/servlet/rtoc","Back to Control page",hp+"/servlet/logout","Logout",pw);
							  } else {
								   count = 1;
								   HtmlGen.writeHeader("Pending participants",pw);
								   pw.println("<h1> Pending participants - "+sat.SharedObjects.qe.getEventName(eventid)+"</h1><hr>");
								   pw.println("<p> Click on the name to view details. Check the box if okayed. Press submit to record changes. Note that once accepted/rejected, you cant do it again. Not selecting someone now is the same as rejecting him</p>");
								   pw.println("<form action="+hp+"/servlet/empending method=POST>");
								   pw.println("<table align=center width=50% cols=3 border=0>");
								   pw.println("<th>LoginId</th><th>Name</th>");
								   e = v.elements();
								   while (e.hasMoreElements()) {
										arr1 = (String)(e.nextElement()); // assume this works
										arr2 = (String)(e.nextElement()); // assume this works
										name = arr2;
										loginid = arr1;

										pw.println("<tr>");
										pw.println("<td>"+loginid+"</td>");
										pw.println("<td><a href="+hp+"/servlet/empd?loginid="+loginid+"&name="+name+">"+name+"</a></td>");
										pw.println("<td><input type=checkbox name=approve"+count+" value=yes></td>");
										pw.println("<input type=hidden name=login"+count+" value="+loginid+">");
										pw.println("<input type=hidden name=name"+count+" value="+name+">");
										pw.println("</tr>");

										count++;
								   }
								   pw.println("</table>");
								   pw.println("<input type=hidden name=count value="+count+">");
								   pw.println("<center><input type=submit value=\"Accept checked\">");
								   pw.println("</form><hr>");
								   HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control page",hp+"/servlet/logout","Logout",pw); 
							  }
						 } else {
							  HtmlGen.writeHeader("Not moderated",pw);
							  pw.println("<h1> Your event is not moderated. Therefore, noone pending approval </h1><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control Page",hp+"/servlet/logout","Logout",pw);
						 }
					}
					pw.close();
			   }
		  }

	 /**
	  * <code>doPost</code> takes a set of accept/reject flags and updates the dbase
	  * correspondingly.
	  *
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException,IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String userid;
			   int usertype;
			   String hp = sat.Config.hostname +":"+sat.Config.port;
			   int count;
			   String loginid;
			   String name;
			   String approved;
			   Vector v;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));

					if (usertype!=0){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 v = new Vector(10,10);
						 count=0;
						 try {
							  count = Integer.parseInt(req.getParameter("count"));
						 } catch (NumberFormatException ne) {}
						 for (int i=1;i<=count;i++) {
							  loginid = req.getParameter("login"+i);
							  name = req.getParameter("name"+i);
							  v.addElement(loginid);
							  v.addElement(name);
							  approved = req.getParameter("approve"+i);
							  if (approved==null) 
								   v.addElement(new Integer(0));
							  else 
								   v.addElement(new Integer(1));
						 }
						 sat.SharedObjects.qe.updatePending(eventid,v);

						 HtmlGen.writeHeader("Update complete",pw);
						 pw.println("<h1> Pending participants update complete - "+sat.SharedObjects.qe.getEventName(eventid)+"</h1><hr>");
						 pw.println("<p> The participant details have been updated. Participants not accepted have been rejected.");
						 HtmlGen.writeFooter(hp+"/servlet/rtoc","Back to Control Page",hp+"/servlet/logout","Logout",pw);
					}
			   }
			   pw.close();
		  }	
}
