package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows an event manager to remove a subevent
 *
 * @author B.Aditya
 * @version 1.00 Sun Oct 15 03:53:10 IST 2000
 */
public class EMRemoveSubEventServlet extends HttpServlet {

	 /**
	  * The <code>doGet</code> method accepts the subeventid, cross checks it with SEName and then deletes.
	  *
	  * @param req HttpRequest
	  * @param res HttpResponse
	  *
	  */
	  public void doGet(HttpServletRequest req,HttpServletResponse res) 
		   throws ServletException, IOException {
				
				HttpSession session;
				PrintWriter pw;
				String userid;
				String eventid;
				int usertype;
				
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
						  
					 if (usertype==0) {
						  HtmlGen.writeHeader("Delete event",pw);
						  pw.println("<h1> Delete event - Enter sub event-id and name </h1>");
						  pw.println("<hr> <form name=deletevent action="+sat.Config.hostname+":"+sat.Config.port+"/servlet/emrse method=POST>");
						  pw.println("<table align=center cols=2 width=50% cellpadding=2 cellspacing=2 border=0>");
						  pw.println("<tr><td>Sub Event-id:</td><td> <input type=text name=subeventid length=20></td></tr>");
						  pw.println("<tr><td><input type=submit value=Delete></td><td><input type=reset value=Reset></td></tr>");
						  pw.println("</table>");
						  HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc","Back to Control",sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout",pw);
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
		   }

	  /**
	   * <code>doPost</code> takes the names sent in by the doGet method and causes a delete on the db.
	   * 
	   * @param req HttpRequest
	   * @param res HttpResponse
	   *
	   */
	  public void doPost(HttpServletRequest req, HttpServletResponse res) 
		   throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String subeventname;
				String subeventid;
				String eventid;
				int usertype;
				boolean success;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
					 
					 if (usertype==0) {
						  eventid =(String)(session.getValue("eventid"));
						  subeventid = req.getParameter("subeventid");

						  success =  sat.SharedObjects.qe.deleteSubEvent(eventid, subeventid);
						  
						  success = true;

						  if (success) {
							   HtmlGen.writeHeader("Delete complete",pw);
							   pw.println("<h1> Delete completed </h1>");
							   pw.println("<p>The delete you requested has been completed.");
							   HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc","Return to Control",sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout",pw);
						  }
						  else {
							   HtmlGen.writeHeader("Delete incomplete",pw);
							   pw.println("<h1> Delete not completed </h1>");
							   pw.println("<p>The delete you requested could not be completed");
							   HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc","Return to Control",sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout",pw);
						  }
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
		   }
}
				
