package sat;

import java.sql.*;

/** a cheapo class which is just used to pass EM spec data as a
 * single object to the <code>QueryEngine</code>.
 *
 * @author Satyen Kale
 * @version 1.00, 29/9/2K
 */
public final class EMSpecData {
	/** lotsa public fields for the various attributes.
	 * all are specified to be package access.
	 */
	public String name;
	public String location;
	public Date startDate;
	public Date endDate;
	public int capacity;
	public int IC_flag;
	public int moderated_flag;

	/**
	 * set start date and end date
	 *
	 * @param start the start date
	 * @param end the end date
	 * @return true if the dates are in correct format, false otherwise
	 */
	public boolean setDates(String start, String end) {
		try {
			startDate = Date.valueOf(start);
			endDate = Date.valueOf(end);
			return true;
		} catch (IllegalArgumentException iae) {
			System.out.println(iae.getMessage());
		}
		return false;
	}
}
