package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * Event Manager Interface - Part 3
 * Is invoked only when Event manager logs in for the first time.
 * Accepts date from him and inserts into database. Also throws out another 
 * page for more details. Can only be called thro doPost
 *
 * @author B. Aditya
 * @version 1.00  Tue Oct  3 15:36:59 IST 2000
 */

public class EMTwoServlet extends HttpServlet 
{
	 public void init()
	 {
	 }

	 /**
	  * Takes all the extra attribs defined by Event Manager and adds to Database
	  * Then returns EM to Control Page
	  *
	  * @param request HttpServletRequest
	  * @param response HttpServletResponse
	  *
	  */
	 public void doPost(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   String event_id;
			   String seattribs[] = new String[10];
			   //int semfill_flag[] = new int[10];
			   int semand[] = new int[10];
			   String pattribs[] = new String[5];
			   //int pfill_flag[] = new int[5];
			   int pmand[] = new int[5];
			   int i;
			   boolean check1,check2;
			   HttpSession session;
			   PrintWriter pw;

			   response.setContentType("text/html");
			   session = request.getSession(false);
			   pw = response.getWriter();
			   

			   if (session==null)
			   {
					HtmlGen.writeHeader("Error",pw);
					pw.println("<h1> Error in processing session</h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					boolean error = false;
					event_id = (session.getValue("eventid")).toString();

					for (i=0;i<=9;i++)
					{
						 seattribs[i] = request.getParameter("seattrib"+i);
						 /*if (request.getParameter("sewhoenters"+i)==null)
							  semfill_flag[i]=1; // sem enters the data
						 else
							  semfill_flag[i]=0; //em enters the data*/
						 if (request.getParameter("seismand"+i)==null) // questiob asked is mandatory?
							  semand[i]=0; // is not mandatory
						 else
							  semand[i]=1; // is mandatory
					}

					for (i=0;i<=4;i++)
					{
						 pattribs[i] = request.getParameter("pattrib"+i);
						/* if (request.getParameter("pwhoenters"+i)==null)
							  semfill_flag[i]=0; //participant enters the data
						 else
							  semfill_flag[i]=1; //sem enters the data*/
						 if (request.getParameter("pismand"+i)==null) // question asked is mandatory?
							  pmand[i]=0; // is not mandatory
						 else
							  pmand[i]=1; // is mandatory
					}

					// now insert into database

					check1 = sat.SharedObjects.qe.insertEMSpecSEAttribs(event_id, seattribs, semand);
					check2 = sat.SharedObjects.qe.insertEMSpecPAttribs(event_id,pattribs, pmand);
					
					if (check1 && check2)
					{
						 // insert successful - so go back to control page.
						 String userid = (session.getValue("userid")).toString();
						 InterfaceObjects.emi.start(pw,userid, event_id,"");
					}
					else
					{
						 // push out page again
						 // read in values till no error.
					     
						 HtmlGen.writeHeader("Sub-event and Participant attribs - retry",pw);
						 pw.println("<h1> Reenter - upto 10 sub-event attributes you would like to add.</h1>");
						 pw.println("<p> Also please check the appropriate box about who fills what!");
						 pw.println("<hr><br><br>");
						 pw.println("<form name=emsa action="+sat.Config.hostname+":"+sat.Config.port+"/servlet/emtwo  method=post>");
						 pw.println("<table align=center width=80% cols=2 frame=null border=0 cellspacing=3 cellpadding=3>");
						 pw.println("<th><td>Attribute Name</td><td>Entered by Event Manager?</td><td> Mandatory? </td></th>");
						 pw.println("<tbody>");
						 for (i=0;i<=9;i++)
						 {
							  pw.println("<tr><td><input type=text name=seattrib"+i+" value=\"\"></td>");
							  pw.println("<td><input type=checkbox name=seismand"+i+"></td></tr>");
						 }
						 pw.println("</tbody></table>");
						 
						 pw.println("<hr><h1> Re-enter upto 5 participant attributes </h1>");
						 pw.println("<p>Also please check the appropriate box about who fills what!");
						 pw.println("<form name=emspa action="+sat.Config.hostname+":"+sat.Config.port+"/servlet/emtwo  method=post>");
						 pw.println("<table align=center width=80% cols=3 frame=null border=0 cellspacing=3 cellpadding=3>");
						 pw.println("<th><td>Attribute Name</td><td>Entered by Sub Event Manager?</td><td> Mandatory? </td></th>");
						 pw.println("<tbody>");
						 for (i=0;i<=4;i++)
						 {
							  pw.println("<tr><td><input type=text name=pattrib"+i+" value=\"\"></td>");
						      //pw.println("<td><input type=checkbox name=pwhoenters"+i+"></td>");
							  pw.println("<td><input type=checkbox name=pismand"+i+"></td></tr>");
						 }
						 pw.println("</tbody></table>");
						 pw.println("<hr><hr>");
						 pw.println("<center> <input type=submit name=submit value=Go> <input type=reset name=reset value=Clear>");
						 pw.println("</form>");
						 
						 HtmlGen.writeFooter("","","","",pw);
					}

			   }	
			   pw.close();
		  }
}
