package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * Event Manager Interface - generates the interface page for an event manager
 * takes a pwrint writer from the calling class.(LoginServlet)
 */

public class EventManagerInterface
{
	 EventManagerInterface()
	 {}

	 /**
	  * Takes a printwriter - and appropriately throws out a control page
	  *
	  * @param pw PrintWriter
	  * @param userid userid of the person logging in
	  * @param eventid The event id of the event
	  * @param subeventid The subeventid - should be null
	  */
	 public void start(PrintWriter pw,String userid,String eventid, String subeventid)
	 {
		  boolean first = sat.SharedObjects.val.firstTime(eventid);
		  if (first)
		  {
			   getAllDetails(pw,userid,eventid);
		  }
		  else 
		  {
			   showControls(pw,userid,eventid);
		  }
	 }

	 /**
	  * <code>showControls</code> generates the controls page for an event manager
	  *
	  * @param pw PrintWriter
	  * @param userid UserId of the Event Manager
	  * @param eventid Event Id of the Event Manager
	  */
	 public void showControls(PrintWriter pw, String userid,String eventid)
	 {
		  String hp = sat.Config.hostname+":"+sat.Config.port;
		  HtmlGen.writeHeader("Event Manager Controls - "+eventid,pw);
		  pw.println("<h1>"+eventid+" - Event Manager Control Page. Welcome "+userid+"</h1>");
		  pw.println("<table align=center cols=1 width=50% frame=null border=0 cellpadding=3 cellspacing=3>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/emves?eventid=" + eventid + "\">View/Modify Event Details</a></td></tr>");
		  //pw.println("<tr><td><a href=\"" + hp + "/servlet/emase\">Add Sub Event</a></td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/emvse\">Add/View/Remove Sub Events</a></td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/emvpi\">View Participant Details</a></td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/empending\">Approve Pending Participants</a></td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/sds?eventid="+eventid+"\">View Schedule</a></td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/srs?eventid="+eventid+"\">View Results</a></td></tr>");
		  pw.println("</table><br><hr>");
	      HtmlGen.writeFooter("" + hp + "/servlet/logout","Logout", "" + hp + "/servlet/cps","Change Password", pw);
	 }

	 /**
	  * <code> getAllDetails is called the first time the event manager logs in.
	  * It shows a form asking for extra details and other stuff.
	  *
	  * @param pw Print Writer of calling servlet
	  * @param userid User Id of event manager
	  * @param eventid Event Id of the event manager
	  */
	 public void getAllDetails(PrintWriter pw, String userid,String eventid)
	 {
		  String hp = sat.Config.hostname+":"+sat.Config.port;
		  HtmlGen.writeHeader("Event Manager Controls - Important Details " + eventid,pw);
		  pw.println("<h1> Event Manager Control Page - Insert Data </h1>");
		  pw.println("<form name="+eventid+"_params action=\""+sat.Config.hostname+":"+sat.Config.port+"/servlet/emone\" method=POST>");
		  pw.println("<table align=center width=50% frame=null border=0>");
		  pw.println("<tr><td>Location:</td><td><input type=text name=location size=20></td></tr>");
		  pw.println("<tr><td>Start Date(yyyy-mm-dd):</td><td><input type=text name=startDate size=20></td></tr>");
		  pw.println("<tr><td>End Date(yyyy-mm-dd):</td><td><input type=text name=endDate size=20></td></tr>");
		  pw.println("<tr><td>Capacity:</td><td>"+sat.SharedObjects.qe.getCapacity(eventid)+"(as set by Administrator)</td></tr>");
		  //pw.println("<tr><td>Capacity:</td><td>"+1000+"(as set by Administrator)</td></tr>");
		  pw.println("<tr><td>Individual Event? :</td><td><input type=checkbox name=IC_flag></td></tr>");
		  pw.println("<tr><td>Moderated? :</td><td><input type=checkbox name=moderated_flag></td></tr>");
		  pw.println("<tr><td><input type=submit value=Submit></td><td><input type=reset value=Reset></td></tr>");
		  pw.println("</table></form>");
		  HtmlGen.writeFooter(hp + "/servlet/logout","Logout now. Enter details later","","",pw);
	 }
}
