package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class GroupSERegisterServlet extends HttpServlet {
	public void init() {
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		HttpSession hs;
		PrintWriter pw;
		String eventid, userid, sid, subeventname, cntgnt_name;
		Vector attribvec;
		Enumeration attribenum;
		Attrib attr;
		QueryEngine qe;
		ContData contdata;
		int teamsize;
		
		qe = sat.SharedObjects.qe;
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");

		if (hs == null) {
			failure(pw);
		} else {
			eventid = (String)(hs.getValue("eventid"));
			userid = (String)(hs.getValue("userid"));
			sid = req.getParameter("sid");
			subeventname = qe.getSubEventName(eventid, sid);
			contdata = qe.getContData(eventid, userid);
			cntgnt_name = contdata.name;
			
			
			attribvec = qe.getSEMSpecPAttribs(eventid, sid);
			hs.putValue("attribvec", attribvec);
			attribenum = attribvec.elements();

			String foo = sat.Config.hostname + ":" + sat.Config.port;

			HtmlGen.writeHeader("Register a team for " + subeventname, pw);
			pw.println("<h1>Register a team from " + cntgnt_name + " for " + subeventname + "</h1><br>");

			pw.println("Please enter the following details for registration: <hr>");
			
			pw.println("<FORM METHOD=POST ACTION=\"" + foo + req.getRequestURI() + "\">");
			pw.println("<INPUT TYPE=hidden NAME=sid VALUE=\"" + sid + "\">");
			pw.println("<TABLE>");
			pw.println("<TR><TD>Contingent : </TD><TD>" + cntgnt_name + "</TD></TR>");
			pw.println("<TR><TD>Event : </TD><TD>" + qe.getEventName(eventid) + "</TD></TR>");
			pw.println("<TR><TD>Sub-event : </TD><TD>" + subeventname + "</TD></TR>");
			pw.println("<TR><TD>Contact Name : </TD><TD><INPUT TYPE=text SIZE=20 NAME=contactname></TD></TR>");
			pw.println("<TR><TD>Contact E-Mail : </TD><TD><INPUT TYPE=text SIZE=20 NAME=contactemail></TD></TR>");
			pw.println("</TABLE><HR>");
			
			pw.println("<TABLE>");
			pw.println("<TR><TD>Team Name : </TD><TD><INPUT TYPE=text SIZE=20 NAME=teamname></TD></TR>");
			teamsize = qe.getTeamSize(eventid, sid);
			
			pw.println("<TR><TD></TD><TD>Member Name</TD><TD>Member E-Mail Address</TD></TR>");
			
			for (int i = 0; i < teamsize; i++) {
				pw.println("<TR><TD>Member " + (i + 1) + "</TD><TD><INPUT TYPE=text SIZE=20 NAME=pname" + i + "></TD>" + 
						  "<TD><INPUT TYPE=text SIZE=30 NAME=email" + i + "></TD></TR>");
			}
			pw.println("</TABLE><HR>");
			
			
			pw.println("<TABLE>");
			while (attribenum.hasMoreElements()) {
				attr = (Attrib)attribenum.nextElement();
				pw.println("<TR><TD>" + attr.name + "</TD><TD><INPUT TYPE=text SIZE=20 NAME=\"" + attr.name + "\"></TD></TR>");
			}
			
			pw.println("<TR><TD><INPUT TYPE=submit NAME=Submit VALUE=Submit></TD>");
			pw.println("<TD><INPUT TYPE=reset NAME=Reset VALUE=Reset></TD></TR>");
			pw.println("</TABLE></FORM>");
			HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		HttpSession hs;
		PrintWriter pw;
		String eventid, userid, sid, subeventname, name, teamname;
		Vector attribvec;
		Enumeration attribenum;
		Attrib attr;
		QueryEngine qe;
		ContData contdata;
		boolean success;
		int teamsize;
		String contactname, contactemail;
		String foo = sat.Config.hostname + ":" + sat.Config.port;

		String[] names;
		String[] emails;
		
		qe = sat.SharedObjects.qe;
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");

		if (hs == null) {
			failure(pw);
		} else {
			eventid = (String)(hs.getValue("eventid"));
			userid = (String)(hs.getValue("userid"));
			sid = req.getParameter("sid");
			subeventname = qe.getSubEventName(eventid, sid);
			contdata = qe.getContData(eventid, userid);
			name = contdata.name;
			teamname = req.getParameter("teamname");
			teamsize = qe.getTeamSize(eventid, sid);
			
			attribvec = (Vector)hs.getValue("attribvec");
			attribenum = attribvec.elements();
			hs.removeValue("attribvec");

			while (attribenum.hasMoreElements()) {
				attr = (Attrib)attribenum.nextElement();
				attr.value = req.getParameter(attr.name);
			}
			
			names = new String[teamsize];
			emails = new String[teamsize];
			
			for (int i = 0; i < teamsize; i++) {
				names[i] = req.getParameter("pname" + i);
				emails[i] = req.getParameter("email" + i);
			}
			
			contactname = req.getParameter("contactname");
			contactemail = req.getParameter("contactemail");
			
			success = qe.insertTeamEntry(eventid, sid, userid, names, emails, teamname, contactname, contactemail);
			
			success = success && qe.insertSEMSpecPVals(eventid, sid, userid, teamname, attribvec);
			
			if (success) {
				HtmlGen.writeHeader("Successful registration for " + subeventname, pw);
				pw.println("<h1>You just registered " + teamname + " from " + name + " for " + subeventname + "</h1><br><hr>");
				pw.println("Now you can modify your profile for " + subeventname + " from your main page.<br>");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			} else {
				HtmlGen.writeHeader("Unsuccessful registration for " + subeventname, pw);
				pw.println("<h1>Unsuccessful registration of " + teamname + " in " + subeventname + "</h1><hr><br>");
				pw.println("Guess you will have to try again !");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			}
		}
	}
	
	public void failure(PrintWriter pw) {
		HtmlGen.writeHeader("Invalid User Session", pw);
		pw.println("<h2>Sorry, it appears you have not logged in. Please proceed to the login page.</h2>");
		HtmlGen.writeFooter("", "", "", "", pw);
	}

}
