package sat;
import java.util.*;

/**
 * this class serves as a wrapper class for all data about an Individual 
 * participant. It has basic attributes like name, email id etc and
 * also has a <code>Vector</code> of SubEvent with info on whether 
 * the Individual participates in the SubEvent or not.
 *
 * @author Satyen Kale
 * @version 1.00, 21/10/2K
 */

public class IndData {
	/** name */
	public String name;

	/** email */
	public String email;

	/** subevents */
	public Vector se;

	/** subevent ID's */
	public Vector sid;

	/** participation info */
	public Vector pi;

	/** EMSpecPVals */
	public Vector attrib_vals;
	
	/**
	 * a constructor
	 */
	public IndData() {
		se = new Vector(10, 10);
		sid = new Vector(10, 10);
		pi = new Vector(10, 10);
		attrib_vals = new Vector(10, 10);
	}

	/**
	 * inserts a SubEvent name into the vectors.
	 *
	 * @param name the name of the SubEvent
	 * @param SEID the ID of the SubEvent
	 * @param flag indicates that the the Individual participates in this SubEvent
	 */
	public void insertSE(String name, String SEID, boolean flag) {
		se.addElement(name);
		sid.addElement(SEID);
		pi.addElement(new Boolean(flag));
	}

	/**
	 * inserts EM spec attrib-values.
	 *
	 * @param name the name of the attrib.
	 * @param val the value of the attrib.
	 */
	public void insertEMSpecPVals(String name, String val) {
		attrib_vals.addElement(new String(name));
		attrib_vals.addElement(new String(val));
	}
}
