package sat;
import java.util.*;

/**
 * this class serves as a wrapper class for all data about an Individual 
 * participant. It has basic attributes like name, email id, pid etc and
 * also has a <code>Vector</code> of SEM spec P Vals
 *
 * @author Satyen Kale
 * @version 1.00, 21/10/2K
 */

public class IndSEData {
	/** name */
	public String name;

	/** email */
	public String email;

	/** pid */
	public int pid;

	/** SEMSpecPVals */
	public Vector attrib_vals;
	
	/**
	 * a constructor
	 */
	public IndSEData() {
		attrib_vals = new Vector(10, 10);
	}

	/**
	 * inserts SEM spec attrib-values.
	 *
	 * @param name the name of the attrib.
	 * @param val the value of the attrib.
	 */
	public void insertSEMSpecPVals(String name, String val) {
		attrib_vals.addElement(new String(name));
		attrib_vals.addElement(new String(val));
	}
}
