package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/** This class allows the user to change his profile for a sub-event
 */
public class IndivSEProfileServlet extends HttpServlet {
	public void init() {
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid, eventid, sid, name, subeventname;
		Vector valvec;
		Enumeration valenum;
		IndData inddata; 
		Attrib attr;
		
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");
		
		if (hs == null) {
			failure(pw);
		} else {
			userid = (String)hs.getValue("userid");
			eventid = (String)hs.getValue("eventid");
			sid = req.getParameter("sid");
			subeventname = sat.SharedObjects.qe.getSubEventName(eventid, sid);
			
			inddata = sat.SharedObjects.qe.getIndData(eventid, userid);
			name = inddata.name;
			
			valvec = sat.SharedObjects.qe.getSEMSpecPAttribVals(eventid, sid, userid, name);
			valenum = valvec.elements();
			hs.putValue("valvec", valvec);
			
			HtmlGen.writeHeader(userid + "@" + sid + ":" + eventid, pw);
			pw.println("<h1>" + subeventname + " - Profile for " + userid + "</h1><br>");
			
			String foo = sat.Config.hostname + ":" + sat.Config.port;
			
			pw.println("<center><form method=post action=\"" + foo + req.getRequestURI() + "\">");
			pw.println("<input type=hidden name=sid value=\"" + sid + "\">");
			pw.println("<table border=0>");
			while (valenum.hasMoreElements()) {
				attr = (Attrib)(valenum.nextElement());
				pw.println("<tr><td>" + attr.name + "</td>");
				pw.println("<td><input type=text size=20 name=\"" + attr.name + "\" value=\"" +
						  attr.value + "\"></td></tr>");
			}
			pw.println("<tr><td><input type=submit name=Submit value=Submit></td>");
			pw.println("<td><input type=reset name=Reset value=Reset></td></tr>");
			pw.println("</table></form></center><hr>");
			HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid, eventid, sid, name, subeventname;
		Vector valvec;
		Enumeration valenum;
		IndData inddata; 
		Attrib attr;
		boolean success;
		
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");
		String foo = sat.Config.hostname + ":" + sat.Config.port;
		
		if (hs == null) {
			failure(pw);
		} else {
			userid = (String)hs.getValue("userid");
			eventid = (String)hs.getValue("eventid");
			sid = req.getParameter("sid");
			subeventname = sat.SharedObjects.qe.getSubEventName(eventid, sid);
			
			inddata = sat.SharedObjects.qe.getIndData(eventid, userid);
			name = inddata.name;
			
			valvec = (Vector)(hs.getValue("valvec"));
			valenum = valvec.elements();
			hs.removeValue("valvec");

			while (valenum.hasMoreElements()) {
				attr = (Attrib)(valenum.nextElement());
				attr.value = req.getParameter(attr.name);
			}

			success = sat.SharedObjects.qe.updateSEMSpecPVals(eventid, sid, userid, name, valvec);
			if (success) {
				HtmlGen.writeHeader("Change Successful", pw);
				pw.println("<h2>Profile Changed Successfully</h2><br>");
				pw.println("Your profile for " + subeventname + " has been changed, " + userid + "!");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			} else {
				HtmlGen.writeHeader("Change Failed", pw);
				pw.println("<h2>Profile not changed</h2><br>");
				pw.println("Some errors were present in the data entered. Please reenter the changes.");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			}
		}
	}
	
	public void failure(PrintWriter pw) {
		HtmlGen.writeHeader("Invalid User Session", pw);
		pw.println("<h2>Sorry, it appears you have not logged in. Please proceed to the login page.</h2>");
		HtmlGen.writeFooter("", "", "", "", pw);
	}
}
