package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class IndivSERegisterServlet extends HttpServlet {
	public void init() {
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		HttpSession hs;
		PrintWriter pw;
		String eventid, userid, sid, subeventname;
		Vector attribvec;
		Enumeration attribenum;
		Attrib attr;
		QueryEngine qe;
		
		qe = sat.SharedObjects.qe;
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");
		
		if (hs == null) {
			failure(pw);
		} else {
			eventid = (String)(hs.getValue("eventid"));
			userid = (String)(hs.getValue("userid"));
			sid = req.getParameter("sid");
			subeventname = qe.getSubEventName(eventid, sid);
			
			attribvec = qe.getSEMSpecPAttribs(eventid, sid);
			hs.putValue("attribvec", attribvec);
			attribenum = attribvec.elements();

			String foo = sat.Config.hostname + ":" + sat.Config.port;
			
			HtmlGen.writeHeader("Register For " + subeventname, pw);
			pw.println("<h1>Register For " + subeventname + ", " + userid + " !</h1><br>");
			pw.println("Please enter the following details for registration: <HR>");
			pw.println("<FORM METHOD=POST ACTION=\"" + foo + req.getRequestURI() + "\">");
			pw.println("<INPUT TYPE=hidden NAME=sid VALUE=\"" + sid + "\">");
			pw.println("<TABLE>");
			pw.println("<TR><TD>Loginid : </TD><TD>" + userid + "</TD></TR>");
			pw.println("<TR><TD>Event : </TD><TD>" + qe.getEventName(eventid) + "</TD></TR>");
			pw.println("<TR><TD>Sub-event : </TD><TD>" + subeventname + "</TD></TR>");
			
			while (attribenum.hasMoreElements()) {
				attr = (Attrib)attribenum.nextElement();
				pw.println("<TR><TD>" + attr.name + "</TD><TD><INPUT TYPE=text SIZE=20 NAME=\"" + attr.name + "\"></TD></TR>");
			}
			pw.println("<TR><TD><INPUT TYPE=submit NAME=Submit VALUE=Submit></TD>");
			pw.println("<TD><INPUT TYPE=reset NAME=Reset VALUE=Reset></TD></TR>");
			pw.println("</TABLE></FORM>");
			HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		HttpSession hs;
		PrintWriter pw;
		String eventid, userid, sid, subeventname, name;
		Vector attribvec;
		Enumeration attribenum;
		Attrib attr;
		QueryEngine qe;
		IndData inddata;
		boolean success;
		String foo = sat.Config.hostname + ":" + sat.Config.port;
		
		qe = sat.SharedObjects.qe;
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");
		
		if (hs == null) {
			failure(pw);
		} else {
			eventid = (String)(hs.getValue("eventid"));
			userid = (String)(hs.getValue("userid"));
			sid = req.getParameter("sid");
			subeventname = qe.getSubEventName(eventid, sid);
			inddata = qe.getIndData(eventid, userid);
			name = inddata.name;
			
			attribvec = (Vector)hs.getValue("attribvec");
			attribenum = attribvec.elements();
			hs.removeValue("attribvec");
			
			while (attribenum.hasMoreElements()) {
				attr = (Attrib)attribenum.nextElement();
				attr.value = req.getParameter(attr.name);
			}
				
			success = qe.insertSEMSpecPVals(eventid, sid, userid, name, attribvec);
			if (success) {
				HtmlGen.writeHeader("Successful registration for " + subeventname, pw);
				pw.println("<h1>Hey " + userid + ", you just like registered for " + subeventname + "</h1><br><hr>");
				pw.println("Now you can modify your profile for " + subeventname + " from your main page.<br>");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			} else {
				HtmlGen.writeHeader("Unsuccessful registration for " + subeventname, pw);
				pw.println("<h1>Unsuccessful registration for " + userid + " in " + subeventname + "</h1><hr><br>");
				pw.println("Guess you will have to try again !");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			}
		}
	}
	
	public void failure(PrintWriter pw) {
		HtmlGen.writeHeader("Invalid User Session", pw);
		pw.println("<h2>Sorry, it appears you have not logged in. Please proceed to the login page.</h2>");
		HtmlGen.writeFooter("", "", "", "", pw);
	}
}
