package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * Event Manager Interface - generates the interface page for an event manager
 * @author		Tejas Iyer
 * @version		Sun Oct 22 03:13:48 IST 2000
 */

public class IndivUserInterface {
	IndivUserInterface() {
	}
	
	/**
	 * Takes a printwriter - and appropriately throws out a control page
	 *
	 * @param pw PrintWriter
	 * @param userid userid of the person logging in
	 * @param eventid Event Id
	 * @param subeventid Sub Event Id - should be null
	 */
	public void start(PrintWriter pw, String userid, String eventid, String subeventid) {
		showControls(pw, userid, eventid);	
	}

	/**
	 * <code>showControls</code> generates the controls page for a individual user
	 *
	 * @param pw PrintWriter
	 * @param userid UserId of the Indiv participant
	 * @param eventid Event Id
	 *
	 */
	public void showControls(PrintWriter pw, String userid, String eventid) {
		IndData inddata;
		String name, email;
		Vector se, sid, pi;
		String sename, seid, eventname;
		Boolean isreg;
		
		inddata = sat.SharedObjects.qe.getIndData(eventid, userid);
		eventname = sat.SharedObjects.qe.getEventName(eventid);
		
		name = inddata.name;
		email = inddata.email;
		se = inddata.se;
		sid = inddata.sid;
		pi = inddata.pi;
		
		HtmlGen.writeHeader("Change Event Profile", pw);
		pw.println("<h1>" + eventname + " - Profile " + userid + "</h1>");
		pw.println("<HR>");

		String foo = sat.Config.hostname + ":" + sat.Config.port + "/servlet/indprofile";
		pw.println("<center><a href=\"" + sat.Config.hostname + ":" + sat.Config.port + "/servlet/sds?eventid="+eventid+"\">View Schedule</a>");
		
		pw.println("<h2>Your Profile</h2>");
		pw.println("<table border=0>");
		pw.println("<tr>");
		pw.println("<td>Name : </td>");
		pw.println("<td>" + name + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td>E-Mail : </td>");
		pw.println("<td>" + email + "</td>");
		pw.println("</tr></table>");
		pw.println("<hr>");
		
		pw.println("<h2>Sub events you have already registered for:</h2>");
		Enumeration e, f, g;
		e = se.elements();
		f = sid.elements();
		g = pi.elements();
		
		foo = sat.Config.hostname + ":" + sat.Config.port + "/servlet/isep";
			 
		pw.println("<table border=0>");
		while (e.hasMoreElements()) {
			sename = (String)(e.nextElement());
			seid = (String)(f.nextElement());
			isreg = (Boolean)(g.nextElement());
			
			if (isreg.booleanValue()) {
				pw.println("<tr><td>" + sename + "</td><td>" + "<a href=\"" 
						  + foo + "?sid=" + seid + "\">View Sub Event Profile</a></td></tr>");
			}
		}
		pw.println("</table>");
		pw.println("<hr>");

		pw.println("<h2>Other Sub-Events in " + eventname + ":</h2>");
		e = se.elements();
		f = sid.elements();
		g = pi.elements();
		
		foo = sat.Config.hostname + ":" + sat.Config.port + "/servlet/iser";
			 
		pw.println("<table border=0>");
		while (e.hasMoreElements()) {
			sename = (String)(e.nextElement());
			seid = (String)(f.nextElement());
			isreg = (Boolean)(g.nextElement());
			
			if (!(isreg.booleanValue())) {
				pw.println("<tr><td>" + sename + " : </td><td>" + "<a href=\"" 
						  + foo + "?sid=" + seid + "\">Register !</a></td></tr>");
			}
		}
		pw.println("</table>");
		pw.println("<hr>");
		
		String hp = sat.Config.hostname + ":" + sat.Config.port;
		pw.println("<a href=\"" + hp + "/servlet/srs?eventid="+eventid+"\">View Results for " + eventname + "</a>");
		pw.println("<hr>");
		
		HtmlGen.writeFooter("" + Config.hostname + ":" + Config.port + "/servlet/logout", "Logout", 
							"" + Config.hostname + ":" + Config.port + "/servlet/cps", "Change Password", pw);
	}
}
