package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * class that allows a subevent manager to add a judge
 *
 * @author B.Aditya
 * @version 1.00 Sat Oct 21 22:54:57 IST 2000
 */
public class SEMAddJudgeServlet extends HttpServlet {

	 /**
	  * <code>doGet</code> displays a form and accepts data.
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   int usertype;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 String hp = sat.Config.hostname + ":" + sat.Config.port;
						 HtmlGen.writeHeader("Add Judge", pw);
						 pw.println("<h1>Enter the required judge details.</h1><hr>");
						 pw.println("<form name=addjud action="+hp+"/servlet/semaddjud method=POST>");
						 pw.println("<table align=center>");
						 pw.println("<tr><td>Email ID:</td><td><input type=text name=email size=20></td></tr>");
						 pw.println("<tr><td>Judge's Name:</td><td><input type=text name=name size=20></td></tr>");
						 pw.println("<tr><td>Phone number:</td><td><input type=text name=phone size=20></td></tr>");
						 pw.println("<tr><td>Address1:</td><td><input type=text name=address1 size=40></td></tr>");
						 pw.println("<tr><td>Address2:</td><td><input type=text name=address2 size=40></td></tr>");
						 pw.println("<tr><td>Fax:</td><td><input type=text name=fax size=20></td></tr>");
						 pw.println("<tr><td><input type=submit value=Submit></td>");
						 pw.println("<tr><td><input type=reset value=Reset></td></tr>");
						 pw.println("</table></form><hr>");
						 HtmlGen.writeFooter(hp+"/servlet/rtoc", "Return to Control Page", hp+"/servlet/semvj", "Back to Judge List", pw);
					}
			   }
		  }

	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   Judge j = new Judge();
			   int usertype;
			   boolean success;
			   String hp = sat.Config.hostname + ":" + sat.Config.port;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 j.email_id = (String)(req.getParameter("email"));
						 j.name = (String)(req.getParameter("name"));
						 j.phone = (String)(req.getParameter("phone"));
						 j.address1 = (String)(req.getParameter("address1"));
						 j.address2 = (String)(req.getParameter("address2"));
						 j.fax = (String)(req.getParameter("fax"));

						 success = sat.SharedObjects.qe.insertJudge(eventid, subeventid, j);

						 if (success) {
							  HtmlGen.writeHeader("Judge Added",pw);
							  pw.println("<h1>Judge added succesfully </h1><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control",hp+"/servlet/semvj","Back to Judge Page",pw);
						 } else {
							  HtmlGen.writeHeader("Judge Not Added",pw);
							  pw.println("<h1>Judge not added succesfully. Please try again.</h1><hr>");
							  pw.println("<center><a href="+hp+"/servlet/semaddjud> Try again </a><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control",hp+"/servlet/semvj","Back to Judge Page",pw);
						 }
					}
			   }
		  }
}
