package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * class that allows a subevent manager to add a result
 *
 * @author B.Aditya
 * @version 1.00 Sat Oct 21 22:54:57 IST 2000
 */
public class SEMAddResultServlet extends HttpServlet {

	 /**
	  * <code>doGet</code> displays a form and accepts data.
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   int usertype;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 String hp = sat.Config.hostname + ":" + sat.Config.port;
						 HtmlGen.writeHeader("Add Result", pw);
						 pw.println("<h1>Enter the required details.</h1><hr>");
						 pw.println("<form name=addres action="+hp+"/servlet/semar method=POST>");
						 pw.println("<table align=center width=50% cols=2 frame=null border=0>");
						 pw.println("<tr><td>Description (position,title):</td><td><input type=text name=name size=40></td></tr>");
						 pw.println("<tr><td>Result (winner's name and the like):</td><td><input type=text name=res size=40></td></tr>");
						 pw.println("<tr><td><input type=submit value=Submit></td>");
						 pw.println("<td><input type=reset value=Reset></td></tr>");
						 pw.println("</table></form><hr>");
						 HtmlGen.writeFooter(hp+"/servlet/rtoc", "Return to Control Page", hp+"/servlet/semres", "Back to Results page", pw);
					}
			   }
		  }

	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   String name,result;
			   int usertype;
			   boolean success;
			   String hp = sat.Config.hostname + ":" + sat.Config.port;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 name = (String)(req.getParameter("name"));
						 result = (String)(req.getParameter("res"));
						 
						 success = sat.SharedObjects.qe.insertResult(eventid, subeventid, name, result);

						// success = true;
						 if (success) {
							  HtmlGen.writeHeader("Result Added",pw);
							  pw.println("<h1>Result added succesfully </h1><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control",hp+"/servlet/semres","Back to Results page",pw);
						 } else {
							  HtmlGen.writeHeader("Result Not Added",pw);
							  pw.println("<h1>Result not added succesfully. Please try again.</h1><hr>");
							  pw.println("<center><a href="+hp+"/servlet/semar> Try again </a><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control",hp+"/servlet/semres","Back to Results page",pw);
						 }
					}
			   }
			   pw.close();
		  }
}
