package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This servlet takes a userid for a subevent and throws out all the details about that
 * participant (be he individual or team)
 *
 * @author B.Aditya
 * @version 1.00 Sat Oct 28 23:48:39 IST 2000
 */
public class SEMPDetailsServlet extends HttpServlet {
	 /**
	  * <code> doGet </code> takes a loginid as parameter from the caller and calls up
	  * the appropriate details and displays all. That's all!!
	  *
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {

			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   int usertype;
			   String loginid;
			   String name,namedash;
			   boolean teambased;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   String hp = sat.Config.hostname +":"+ sat.Config.port;

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 System.out.println("Here - starting work");
						 loginid = req.getParameter("loginid");
						 namedash = req.getParameter("name");
						 name = namedash.replace("~".charAt(0)," ".charAt(0));
						 System.out.println("name is "+name+":"+loginid);
						 HtmlGen.writeHeader("Participant details",pw);
						 pw.println("<h1>  Participant details </h1><hr>");
						 // now to check if indiv or team.
						 // if indiv, throw out all appropriate details
						 // if team, get contingent details as well as team details.
						 teambased = sat.SharedObjects.val.isTeamBased(eventid);
						 System.out.println("name is "+name+":"+loginid+":"+teambased);
						 if (teambased) {
							  ContData cd;
							  TeamSEData tsed;
							  Enumeration e1,e2,e3;
							  String arr1;
							  String arr2;
							  String monika;

							  Object obj;

							  cd = sat.SharedObjects.qe.getContData(eventid,loginid);
							  tsed = sat.SharedObjects.qe.getTeamSEData(eventid,subeventid,loginid);


							  pw.println("<p> Team Details </p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<tr><td>Team Name</td><td>"+tsed.team_name+"</td></tr>");
							  pw.println("<tr><td>PID</td><td>"+tsed.pid+"</td></tr>");
							  pw.println("<tr><td>Contact EMail</td><td>"+tsed.email+"</td></tr>");
							  pw.println("</table>");

							  pw.println("<table align=center cols=2 width=30% border=0>");
							  pw.println("<th>Team Members</th><th>EMailID</th>");
							  if (tsed.members!=null) {
								   e3 = tsed.members.elements(); // member names
								   while (e3.hasMoreElements()) {
										obj = e3.nextElement();
										monika = (String)obj;
										pw.println("<tr><td>"+monika+"</td>");
										obj = e3.nextElement();
										monika = (String)obj;
										pw.println("<td>"+monika+"</td></tr>");
								   }
							  }
							  pw.println("</table><hr>");
							  pw.println("<p>Values of attributes specified by you!</p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<th>Attribute</th><th>Value</th>");
							  if (tsed.attrib_vals!=null) {
								   e2 = tsed.attrib_vals.elements(); // SEMSpecPVals
								   while (e2.hasMoreElements()) {
										arr1 = (String)(e2.nextElement());
										arr2 = (String)(e2.nextElement());
										pw.println("<tr><td>"+arr1+"</td><td>"+arr2+"</td></tr>");
								   }
							  }
							  pw.println("</table><hr>");

							  pw.println("<p> Contingent Details</p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<tr><td>Contingent Name</td><td>"+cd.name+"</td></tr>");
							  pw.println("<tr><td>CL Name</td><td>"+cd.cl_name+"</td></tr>");
							  pw.println("<tr><td>Contact Email</td><td>"+cd.email+"</td></tr>");
							  pw.println("</table>");
							  pw.println("<p>Values of EM Specified attributes </p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<th>Attribute</th><th>Value</th>");
							  if (cd.attrib_vals!=null) {
								   e1 = cd.attrib_vals.elements(); // EMSpec PVals
								   while (e1.hasMoreElements()) {
										arr1 = (String)(e1.nextElement());
										arr2 = (String)(e1.nextElement());
										pw.println("<tr><td>"+arr1+"</td><td>"+arr2+"</td></tr>");
								   }
							  }
							  pw.println("</table><hr>");
							  if (req.getParameter("from")==null) 
								   HtmlGen.writeFooter(hp+"/servlet/sempending","Back to Pending list",hp+"/servlet/rtoc","Back to Control Page",pw);
							  else 
								   HtmlGen.writeFooter(hp+"/servlet/semreg","Back to Participant List",hp+"/servlet/rtoc","Back to Control Page",pw);
						 } else {
							  // individual based. 
							  IndData id;
							  IndSEData ised;
							  Enumeration e1,e2,e3,e4,e5;
							  System.out.println("Indiv based.");

							  id = sat.SharedObjects.qe.getIndData(eventid, loginid);
							  System.out.println("first fn. based.");
							  ised = sat.SharedObjects.qe.getIndSEData(eventid,subeventid, loginid);
							  String arr1,arr2;

							  System.out.println("Going to get the enums");
							  e1 = id.sid.elements(); // subeventid
							  e2 = id.se.elements();  // subevent names
							  e3 = id.pi.elements();  // participation for above (approved or not)
							  e4 = id.attrib_vals.elements(); // EMSpec PVal
							  pw.println("<table align=center width=50% cols=2 border=0>");
							  pw.println("<tr><td>Name :</td><td>"+id.name+"</td></tr>");
							  pw.println("<tr><td>Email ID :</td><td>"+id.email+"</td></tr>");
							  pw.println("</table>");
							  pw.println("<hr><p>Event Manager Specified Participant values</p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<th>Attribute</th><th>Value</th>");
							  System.out.println("Enum4");
							  while (e4.hasMoreElements()) {
								   arr1 = (String)(e4.nextElement());
								   arr2 = (String)(e4.nextElement());
								   pw.println("<tr><td>"+arr1+"</td><td>"+arr2+"</td></tr>");
							  }
							  pw.println("</table><hr>");
							  pw.println("<p> This participant has applied to participate in the foll subevents as well</p>");
							  pw.println("<table align=center cols=3 width=50% border=0>");
							  pw.println("<th>SubEvent ID</th><th>SubEvent Name</th><th>Approved?</th>");
							  System.out.println("Enum1");
							  while (e1.hasMoreElements()) { // e1, e2 and e3 are all equal in length
								   String se,seid;
								   boolean flag;
								   seid = (String)(e1.nextElement());
								   se = (String)(e2.nextElement());
								   flag = ((Boolean)(e3.nextElement())).booleanValue();
								   pw.println("<tr>");
								   pw.println("<td>"+seid+"</td>");
								   pw.println("<td>"+se+"</td>");
								   if (flag) 
										pw.println("<td> Yes </td>");
								   else
										pw.println("<td> No </td>");
								   pw.println("</tr>");
							  }
							  pw.println("</table><hr>");

							  e5 = ised.attrib_vals.elements(); // SEMSpec P Vals
							  pw.println("<p> Values of attributes specified by you!</p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<th>Attribute</th><th>Value</th>");
							  System.out.println("Enum5");
							  if (ised.attrib_vals!=null) {
								   e5 = ised.attrib_vals.elements(); // SEMSpec P Vals
								   while (e5.hasMoreElements()) {
										System.out.println("Class cast here??");
										arr1 = (String)(e5.nextElement());
										System.out.println("Class cast here??");
										arr2 = (String)(e5.nextElement());
										pw.println("<tr><td>"+arr1+"</td><td>"+arr2+"</td></tr>");
								   }
							  } else {
								   System.out.println("vector is null");
							  }
							  pw.println("</table></hr>");
							  if (req.getParameter("from")==null) 
								   HtmlGen.writeFooter(hp+"/servlet/sempending","Back to Pending list",hp+"/servlet/rtoc","Back to Control Page",pw);
							  else 
								   HtmlGen.writeFooter(hp+"/servlet/semreg","Back to Participant List",hp+"/servlet/rtoc","Back to Control Page",pw);
						 }
					}
			   }
			   pw.close();
		  }
}
