package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class displays the details of all the registered participants and allows SEM to
 * insert the SEM_Spec_SEM_Filled data.
 *
 * @author B.Aditya
 * @version 1.00 Mon Nov  6 23:13:35 IST 2000
 */
public class SEMRegisteredServlet extends HttpServlet {
	 /**
	  * <code> doGet </code> displays a list of approved/registered participants for the
	  * subevent and then allows the SEM to update the details required to be filled by SEM. 
	  *
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res)
		  throws ServletException, IOException {

			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   String name,loginid,attrib,val;
			   int usertype;
			   int noreg;
			   boolean teambased;
			   Attrib a;
			   Vector v1,v2,v3;
			   Enumeration e1,e2,e3;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   String hp = sat.Config.hostname+":"+sat.Config.port;

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));


					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 noreg = 0;
						 v1 = sat.SharedObjects.qe.getSubEventParticipants(eventid,subeventid);
						 // above returns a vector of name, loginid for the subevent who
						 // have been approved and are therefore registered.
						 
						 v2 = sat.SharedObjects.qe.getSEMFilledPAttribs(eventid, subeventid);

						 HtmlGen.writeHeader("Registered Participants",pw);
						 pw.println("<h1> Registered Participant details </h1>");
						 pw.println("<p> Click on the name for details entered by the participant. Fill in the details alongside and press submit to update.");

						 if (v1==null) {
							  pw.println("<hr> <p>No registered Participants. Happy Happy Joy Joy");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control Page",hp+"/servlet/logout","Logout",pw);
						 } else {  
							  noreg = v1.size();
							  System.out.println("No of flos = "+noreg);
							  e1 = v1.elements();
							  
							  pw.println("<form action="+hp+"/servlet/semreg method=POST>");
							  pw.println("<table align=center width=80% border=0>");
							  pw.println("<th>Login Id</th><th>Name</th>");
							  if (v2!=null) {
								   e2 = v2.elements();
								   while (e2.hasMoreElements()) {
										a = (Attrib)(e2.nextElement());
										pw.println("<th>"+a.name+"</th>");
								   }
							  } else {
							  }
							  int i=1;
							  while (e1.hasMoreElements()) {
								   pw.println("<tr>");
								   loginid = (String)(e1.nextElement());
								   name = (String)(e1.nextElement());
								   String namedash = name.replace(" ".charAt(0),"~".charAt(0));
								   pw.println("<td>"+loginid+"</td>");
								   pw.println("<td> <a href="+hp+"/servlet/sempd?name="+namedash+"&loginid="+loginid+"&from=reg>"+name+"</a></td>");

								   v3 = sat.SharedObjects.qe.getSEMFilledPAttribVals(eventid, subeventid, loginid, name);
								   if (v3!=null) {
										if (i==1)
											 hs.putValue("attribv",v3);
										e3 = v3.elements();
										System.out.println("No of attribs for flo = "+v3.size());
										// now for every flo, have to look up the vector and pick
										// out those that are sem filled and print here...
										pw.println("<input type=hidden name=name"+i+" value=\""+name+"\">");
										pw.println("<input type=hidden name=loginid"+i+" value=\""+loginid+"\">");

										while (e3.hasMoreElements()) {
											 pw.println("<td>");
											 a = (Attrib)(e3.nextElement());
											 attrib = a.name;
											 val = a.value;
											 System.out.println("generating page - attrib:"+attrib+i+"value:"+val);
											 pw.println("<input name=\""+attrib+i+"\" type=text value=\""+val+"\">");
											 pw.println("</td>");
										}
								   } else {}
								   pw.println("</tr>");
								   i++;
							  }
							  pw.println("</table>");
							  pw.println("<input type=submit value=Submit>");
							  pw.println("<input type=hidden name=rowcount value="+noreg/2+">");
							  pw.println("</form>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control Page",hp+"/servlet/logout","Logout",pw);
						 }
					}
			   }
		  }

	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   String name,loginid,attrib;
			   int usertype;
			   int rowcount;
			   Vector v1,v2; 
			   Enumeration e;
			   Attrib a;
			   boolean success=true;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   String hp = sat.Config.hostname+":"+sat.Config.port;

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 rowcount = Integer.parseInt(req.getParameter("rowcount"));
						 System.out.println("no of flos registered="+rowcount);
						 v1 = (Vector)(hs.getValue("attribv"));
						 // now iterate over 1 to rowcount and get all the vals and put.
						 for (int i=1;i<=rowcount;i++) {
							  name = req.getParameter("name"+i);
							  loginid = req.getParameter("loginid"+i);
							  v2 = new Vector(10,10);
							  e = v1.elements();
							  while (e.hasMoreElements()) {
								   a = (Attrib)(e.nextElement());
								   attrib = a.name;
								   System.out.println("going for"+attrib+i+"");
								   a.value = req.getParameter(attrib+i+"");
								   System.out.println("reg update for"+name+":"+loginid+":"+a.name+":"+a.value);
								   v2.addElement(a);
							  }
							  success = (success && sat.SharedObjects.qe.updateSEMFilledPVals(eventid,subeventid,loginid,name,v2));
						 }

						 if (success==true) {
							  HtmlGen.writeHeader("Successful insert",pw);
							  pw.println("<h1> Successful update. </h1>");
							  pw.println("<hr>");
							  HtmlGen.writeFooter(hp+"/servlet/semreg","Back to registered list",hp+"/servlet/rtoc","Back to Control Page",pw);
						 } else {
							  HtmlGen.writeHeader("Update failed",pw);
							  pw.println("<h1> Update failed. Please try again </h1>");
							  pw.println("<hr>");
							  HtmlGen.writeFooter(hp+"/servlet/semreg","Back to registered list",hp+"/servlet/rtoc","Back to Control Page",pw);
						 }
					}
			   }
		  }
}
