package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows a SEM to remove a judge.
 * Data(email id of the judge) is posted to this function.
 * @author B.Aditya
 * @version 1.00 Tue Oct 24 01:00:19 IST 2000
 */
public class SEMRemoveJudgeServlet extends HttpServlet {
	  /**
	   * <code>doPost</code> takes an email id of a judge as a parameter and removes it.
	   * 
	   * @param req HttpRequest
	   * @param res HttpResponse
	   *
	   */
	  public void doPost(HttpServletRequest req, HttpServletResponse res) 
		   throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String subeventid;
				String eventid;
				int usertype;
				boolean success;
				String judgeEmail;
				String hp = sat.Config.hostname+":"+sat.Config.port;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
					 
					 if (usertype==1) {
						  eventid =(String)(session.getValue("eventid"));
						  subeventid = req.getParameter("subeventid");
						  judgeEmail = req.getParameter("jemail");

						  success =  sat.SharedObjects.qe.deleteJudge(eventid, subeventid,judgeEmail);
						  
						  if (success) {
							   HtmlGen.writeHeader("Judge Removed",pw);
							   pw.println("<h1> Judge has been derascinated! </h1>");
							   pw.println("<p>He (or if you are PC, she) no longer exists in your domain. Rejoice!!");
							   HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge list",hp+"/servlet/rtoc","Return to Control Page",pw);
						  }
						  else {
							   HtmlGen.writeHeader("Delete incomplete",pw);
							   pw.println("<h1> Delete not completed </h1>");
							   pw.println("<p>The delete you requested could not be completed");
							   HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge list",hp+"/servlet/rtoc","Return to Control Page",pw);
						  }
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
				pw.close();
		   }
}
				
