package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows a SEM to update judge details
 * All judge details are posted to this servlet 
 * @author B.Aditya
 * @version 1.00 Sat Oct 28 17:52:50 IST 2000
 */
public class SEMUpdateJudgeServlet extends HttpServlet {
	  /**
	   * <code>doPost</code> takes all judge details and updates the database.
	   * 
	   * @param req HttpRequest
	   * @param res HttpResponse
	   *
	   */
	  public void doPost(HttpServletRequest req, HttpServletResponse res) 
		   throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String subeventid;
				String eventid;
				int usertype;
				boolean success;
				Judge j;
				String hp = sat.Config.hostname+":"+sat.Config.port;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);
				j = new Judge();

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
					 
					 if (usertype==1) {
						  eventid =(String)(session.getValue("eventid"));
						  subeventid = (String)(session.getValue("subeventid"));

						  j.name = (String)(req.getParameter("name"));
						  j.email_id = (String)(req.getParameter("email"));
						  j.address1 = (String)(req.getParameter("add1"));
						  j.address2 = (String)(req.getParameter("add2"));
						  j.phone = (String)(req.getParameter("phone"));
						  j.fax = (String)(req.getParameter("fax"));
						  
						  success =  sat.SharedObjects.qe.updateJudge(eventid, subeventid,j);
						  
						  
						  if (success) {
							   HtmlGen.writeHeader("Judge Details updated",pw);
							   pw.println("<h1> Judge details updated </h1>");
							   pw.println("<p>Judge details have been updated to the following values:");
							   pw.println("<table align=center width=40% cols=2 border=0>");
							   pw.println("<tr><td>Name:</td><td>"+j.name+"</td></tr>");
							   pw.println("<tr><td>Email Id:</td><td>"+j.email_id+"</td></tr>");
							   pw.println("<tr><td>Address 1:</td><td>"+j.address1+"</td></tr>");
							   pw.println("<tr><td>Address 2:</td><td>"+j.address2+"</td></tr>");
							   pw.println("<tr><td>Phone:</td><td>"+j.phone+"</td></tr>");
							   pw.println("<tr><td>Fax:</td><td>"+j.fax+"</td></tr>");
							   pw.println("</table>");
							   HtmlGen.writeFooter(hp+"/servlet/semvj","View judge list again",hp+"/servlet/rtoc","Go back to Control page",pw);
						  }
						  else {
							   HtmlGen.writeHeader("Update unsuccessful",pw);
							   pw.println("<h1> Update unsuccessful </h1>");
							   pw.println("<p> Please try again </p>");
							   HtmlGen.writeFooter(hp+"/servlet/semvj","View Judge list again",hp+"/servlet/rtoc","Go back to Cotnrol page",pw);
						  }
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
				pw.close();
		   }
}
				
