package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class ScheduleDisplayerServlet extends HttpServlet {
	public void init() {
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		PrintWriter pw;
		String eventid, subeventname, eventname, oldsubeventname;
		QueryEngine qe;
		Vector sched_info_vec;
		Enumeration sched_info_enum;
		TimeInfo time_info;
		boolean atleast_one = false;
		
		// specified as a parameter in the link to this servlet
		eventid = req.getParameter("eventid");
		qe = sat.SharedObjects.qe;
		eventname = qe.getEventName(eventid);
		pw = res.getWriter();
		res.setContentType("text/html");
		oldsubeventname = new String("betchathisdontexist");
		
		sched_info_vec = qe.getEventSchedule(eventid);
		if (sched_info_vec == null) 
			failure(pw);
		else {
			HtmlGen.writeHeader("Schedule for " + eventname, pw);
			pw.println("<h1>Schedule for " + eventname + "</h1><hr>");
			 
			sched_info_enum = sched_info_vec.elements();
			
			while (sched_info_enum.hasMoreElements()) {
				atleast_one = true;
				subeventname = (String)(sched_info_enum.nextElement());
				if (!(oldsubeventname.equals(subeventname))) {
					if (!(oldsubeventname.equals("betchathisdontexist"))) {
						pw.println("</table><hr>");
					}
					pw.println("<h2>" + subeventname + "</h2>");
					pw.println("<table>");
					pw.println("<th>Date</th><th>Start Time</th><th>End Time</th>");
					oldsubeventname = subeventname;
				}
				time_info = (TimeInfo)(sched_info_enum.nextElement());
				pw.println("<tr><td>" + time_info.date + "</td><td>" + time_info.start_time +
						  "</td><td>" + time_info.end_time + "</td></tr>");
			}

			if (atleast_one) pw.println("</table><hr>");
			
			HtmlGen.writeFooter("", "", "", "", pw);
		}
	}


	public void failure(PrintWriter pw) {
		HtmlGen.writeHeader("Invalid Event Schedule Requested", pw);
		pw.println("<h2>Buh, event existeth nicht !</h2>");
		HtmlGen.writeFooter("", "", "", "", pw);
	}
}
