package tejas;
import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import sat.SharedObjects;

/**
 * This class allows the user to choose the subevent whose results are to be 
 * viewed.
 *
 * @author Vijay
 * @version 1.00,1 October 2000
 */
public class ShowResultsServlet extends HttpServlet{
	 /**
	  * Init Function..
	  */
	 public void init(){
	 }

	 /**
	  * POST's the results of the Event. It is assumed that eventid is
	  * passed as a parameter from the calling page.
	  * @param req  The HttpServletRequest sent by the calling page.
	  * @param res  The HttpServletResponse contains the results of the subevent.
	  */
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
		  String eventid,eventname;
		  String name,result; //The participant name and the result.
		  PrintWriter pw;
		  ResultSet subevents = null;

		  eventid = request.getParameter("eventid");
		  eventname = sat.SharedObjects.qe.getEventName(eventid);
		  pw = response.getWriter();
		  response.setContentType("text/html");

		  //If the session is void.. well either error or the person shouldnot 
		  //have gotten here in  the first place.

		  //EventID should be passed from the calling page as a hidden parameter.
		  start(pw,eventname,eventid);
		  try{
			   subevents = sat.SharedObjects.qe.getSubEvents(eventid);
			   while(subevents.next()){
					pw.print("<tr><td>");
					pw.print("<a href=\""+sat.Config.hostname+":"+sat.Config.port+"/servlet/vrs?eventid="+eventid+"&subeventid="+subevents.getString(1)+"\">"+ subevents.getString(2)+"</a></td>");
					pw.println("</tr>");
			   }
		  } catch(SQLException e) {
			  System.err.println("SQL Exception in ShowResultsServlet !");
		  }
		  pw.println("</tbody>");
		  pw.println("</table>");
		  pw.println("</center>");
	 }

	 /** 
	  * Spews out the template page for displaying the results.
	  *
	  * @param pw PrintWriter
	  * @param eventid String which gives the Event-ID
	  */
	 void start(PrintWriter pw, String eventname,String eventid){
		  String Title = "Results for " + eventname;
		  HtmlGen.writeHeader(Title,pw);
		  pw.println("<h1> Choose the Sub-Event Results to view</h1>");
		  pw.println("<hr><br><br>");
		  pw.println("<center>");
		  pw.println("<table bgcolor=fffff0 width=85%  cellspacing=0 cellpadding=1>");
		  pw.println("<input type=hidden name=eventid value="+eventid+">");
		  pw.println("<tr bgcolor=deb877><th>Sub Events</th></tr>");
		  pw.println("<tbody>");
	 }   
}
