package sat;
import java.util.*;

import java.sql.*;

/** a cheapo class which is just used to pass SubEvent data as a
 * single object to the <code>QueryEngine</code>.
 *
 * @author Satyen Kale
 * @version 1.00, 29/9/2K
 */
public final class SubEventData {
	/** lotsa public fields for the various attributes.
	 */
	public String event_id;
	public String subevent_id;
	public String subevent_name;
	public String venue;
	public int capacity;
	public int moderation_flag;
	public int team_size = 1; /** 1 for individual based events */
	
	/** a <code>Vector</code> of <code>TimeInfo</code> objects
	 * for this SubEvent */
	public Vector times;

	/** a <code>Vector</code> of <code>Attrib</code> objects
	 * for the EM spec attributes.
	 */
	public Vector attrib_vals;
	
	public void insertTimeInfo(String d, String st, String et) {
		if (times == null) {
			times = new Vector(10, 10);
		}
		TimeInfo ti = new TimeInfo();
		ti.set(d, st, et);
		times.addElement(ti);
	}

	/**
	 * inserts an attrib-value pair into the <code>attrib_vals Vector</code>
	 *
	 * @param attrib the name of the attribute
	 * @param val the value of the attribute
	 */
	public void insertAttribVal(String attrib, String val) {
		if (attrib_vals == null) {
			 attrib_vals = new Vector(10, 10);
		}
		Attrib a = new Attrib(attrib, false);
		a.value = val;
		attrib_vals.addElement(a);
	}
}
