package sat;
import java.util.*;

/**
 * this class serves as a wrapper class for all data about a Team 
 * participant. It has basic attributes like team_name, email id, pid etc and
 * also has a <code>Vector</code> of SEM spec P Vals, plus a 
 * <code>Vector</code> of team member names.
 *
 * @author Satyen Kale
 * @version 1.00, 21/10/2K
 */

public class TeamSEData {
	/** name */
	public String team_name;

	/** contact name */
	public String name;

	/** email */
	public String email;

	/** pid */
	public int pid;

	/** SEMSpecPVals */
	public Vector attrib_vals;

	/** team member names */
	public Vector members;

	/**
	 * a constructor
	 */
	public TeamSEData() {
		attrib_vals = new Vector(10, 10);
		members = new Vector(10, 10);
	}

	/**
	 * inserts SEM spec attrib-values.
	 *
	 * @param name the name of the attrib.
	 * @param val the value of the attrib.
	 */
	public void insertSEMSpecPVals(String name, String val) {
		attrib_vals.addElement(new String(name));
		attrib_vals.addElement(new String(val));
	}

	/**
	 * inserts a new member (name, email) into the members <code>Vector</code>
	 *
	 * @param name the member name
	 * @param email the member email ID
	 */
	public void insertMember(String name, String email) {
		members.addElement(new String(name));
		members.addElement(new String(email));
	}
}
