import java.sql.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class resultServlet extends HttpServlet 
{
  Connection myCon = null ;  

  public void init(ServletConfig config) throws ServletException 
  {
	  super.init(config) ;
	  try{ 
	        Class.forName(Config.DRIVER);
	        myCon=
	        DriverManager.getConnection(Config.CONN,Config.USR,Config.PASS);
	  } 
       	  catch (ClassNotFoundException e){ 
		   throw new UnavailableException(this,"unable to load driver"); 	  } 
	  catch (SQLException e){ 
		   throw new UnavailableException(this,"unable to connect"); 
	  }
 }

	public void doGet(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException
	{
		res.setContentType("text/html") ;
		PrintWriter out = res.getWriter() ;

		ResultSet rs = null ;
		Statement st ;
		String cat, str, yr;

		try{
			st = myCon.createStatement();
			rs = st.executeQuery( "select * from result" );
			rs.next() ;

			    out.println("<h3>");
			    out.println("<html><head><title> result </title>") ;
		       	    out.println("</head><body bgcolor=lightblue><h1> Mathematics Olympiad");
			    out.println(" Results for MO-"+rs.getString(3)+"</h1><h2>") ;
			    out.println("Select the category whose result you want to see. If want to see any individual result, enter the registration number in the text box provided below.</h2>") ;
                	    out.println("<form action=\""+Config.HSER+"resultServlet\" method=\"post\">") ;
			    out.println("<br><br><li><B>Search by category");
			    out.println("<select name=\"cat\">") ;
                            out.println("<option value=\"a\">All</option>");
                            out.println("<option value=\"j\">Juniors</option>");
		            out.println("<option value=\"s\">Seniors</option>");
		            out.println("<option value=\"i\">IITians</option>");
                            out.println("<option value=\"n\">Non-students</op");
                            out.print("tion></select></B><br><br>");
                            out.println("<li><B>Search by registration number");
                            out.println("<input name=rno value=\"\" size=5>");
                            out.println("</B><br><br>") ;
                            out.println("<input type=submit value=submit>");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
		            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp");
                            out.println("<input type=reset value=cancel>");
                            out.println("<br><br>") ;
	 	            out.println("</body></html>"); 
		}
		catch (Exception e){
			out.println("<html><head><title>Boom!</title></head><body bgcolor=white text=black><font color=red size=5>Error Occured</font><br><br><hr> Read the instructions carefully and check your input.<br><br></body></html>"); 
		}
	}


	public void doPost(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException
	{
		res.setContentType("text/html") ;
		PrintWriter out = res.getWriter() ;

		ResultSetMetaData rsmd = null, rsd = null ;
		ResultSet rs = null , rset = null, resAvg=null, RS=null ;
		ResultSet rsetMax = null, rsetMin = null ;
		Statement st, stmt, stm ,s ,stmnt, stat ;
		String cat, rno ;
		int i, cnt, max, min, count ;

		try{
			cat = req.getParameter("cat") ;
			rno = req.getParameter("rno") ;

			if( !rno.equals("")) 
			{
				st = myCon.createStatement() ;
				rs = st.executeQuery("select Marks from Result where Registration_Number='"+rno+"'") ;
				if(!rs.next())
				{
					out.println("<html><head><title>absent</title>") ;
					out.println("</head><body><h1> Either the registration number does not exist or the candidate didn't appear in the MO") ;
					out.println("</h1></body></html>") ;
				}
				else
				{
					stmt = myCon.createStatement() ;
					rset = stmt.executeQuery("select First_name, Last_Name, Institute from merge where Registration_Number='"+rno+"'") ;
					rset.next() ;
					out.println("<html><head><title>present</title>") ;
					out.println("</head><body><h1> Hi!! "+rset.getString(1)+" You got "+rs.getString(1)) ;
					out.println("<h2> Thanks a lot to you on behalf of Mathematics Association for showing enthusiasm and taking part in this grand competition. Keep visiting to MO HomePage and we will let you know about other coming events and BASH !! </h2>") ;   
					out.println("</h1></body></html>") ;
				}
			}
			else
			{
				cat = req.getParameter("cat") ;
				st = myCon.createStatement();
				stat = myCon.createStatement();
				stm=myCon.createStatement();
				stmt=myCon.createStatement();
				s=myCon.createStatement();
				stmnt=myCon.createStatement();
				
				if( cat.equals( "a" ) )
					cat = "merge" ;
				else if(cat.equals("j"))
					cat = "juniors" ;
				else if(cat.equals("s"))
					cat = "seniors" ;
				else if(cat.equals("i"))
					cat = "iitians" ;
				else if(cat.equals("n"))
					cat = "non_students" ;
					
				rs = st.executeQuery( "select Result.Registration_Number, First_Name, Last_Name, Institute, Result.Marks from "+cat+", result where "+cat+".registration_number=result.registration_number  order by Registration_Number" );
				resAvg=stmnt.executeQuery("select avg(result.marks) from result,"+cat+" where "+cat+".registration_number=result.registration_number");
				rsetMax=stm.executeQuery("select max(result.marks) from result,"+cat+" where "+cat+".registration_number=result.registration_number");
				rsetMax.next();
				rsetMin=s.executeQuery("select min(result.marks) from result,"+cat+" where "+cat+".registration_number=result.registration_number");
				rset = stmt.executeQuery("select result.registration_number, first_name, last_name, institute from result,"+cat+" where result.registration_number="+cat+".registration_number and result.marks="+rsetMax.getString(1));
				rsmd = rs.getMetaData() ;
				rsd = rset.getMetaData() ;
				count = rsmd.getColumnCount() ;
				cnt = rsd.getColumnCount() ;
					
				out.println("<html><head><title>Result</title></head><body>");
				out.println("<br><h1>RESULTS : </h1>");
				out.println("<h3><table align=center border=5>");
				out.println("<tr>") ;
				for(i=1; i <= count ; i ++)
				out.println("<td><font size=\"5\">"+rsmd.getColumnName(i)+"</font></td>");
				out.println("</tr>");
				
				while( rs.next() )
				{
					out.println("<tr>") ;
					for(i=1; i <= count ; i ++)
						out.println("<td><font size=\"5\">"+rs.getString(i)+"</font></td>");
					out.println("</tr>");
				}
				out.println("</table></h3><br><br>");
				out.println("<h1><BLINK>WINNER(S):</BLINK>");
				out.println("</h1><h2><table align=center border=5>");
				out.println("<tr>") ;
				for(i=1; i <= cnt ; i ++)
				     out.println("<td><font size=\"5\">"+rsd.getColumnName(i)+"</font></td>");
				out.println("</tr>");
				while(rset.next())
				{
		 			out.println("<tr>") ;
					for(i=1; i <= cnt ; i ++)
					  out.println("<td><font size=\"5\">"+rset.getString(i)+"</font></td>");
				 	  out.println("</tr>");
				}
				out.println("</table></h2>");

				resAvg.next() ;
				rsetMin.next();
		
				out.println("<br><br><h1>PERFORMANCE(S):</h1>");
				out.println("<h2>Maximum marks for the above category is : "+rsetMax.getString(1)+"</h2>");
				out.println("<h2>Average marks for the above category is : "+resAvg.getString(1)+"</h2>");
				out.println("<h2>Minimum marks for the above category is : "+rsetMin.getString(1)+"</h2>");
			
				max=Integer.parseInt(rsetMax.getString(1)) ;
				if( max%10 != 0)
					max = ((max/10)+1)*10 ;
				
				min=Integer.parseInt(rsetMin.getString(1)) ;
				if( min%10 != 0)
					min = ((min/10)+1)*10-9 ;
				else
					min = (min/10-1)*10+1 ;
				
				out.println("<table align=center border=5>");
				out.println("</h2><tr>") ;
			        out.println("<font size=\"5\"><td>Range</td><td>Number of Students</td></font>");
				out.println("</tr>");
				for( i = min; i<=max; i=i+10)
				{
					RS=stat.executeQuery("select count(result.registration_number) from result,"+cat+" where result.marks between "+i+" and "+(i+9)+" and result.registration_number="+cat+".registration_number"); 
					RS.next();
		 			out.println("<tr>") ;
					out.println("<font size=\"5\"><td>"+i+" to "+(i+9)+"</td><td><center>"+RS.getString(1)+"</center></td></font>");
				 	out.println("</tr>");
				}
				out.println("</h2></table><br><br>");

				out.println("<a href=\""+Config.HSER+"resultServlet\"><center>Back</center></a></body></html>"); 
			}
		}
		catch (Exception e){
			out.println("<html><head><title>Boom!</title></head><body bgcolor=white text=black><font color=red size=5>Error Occured</font><br><br><hr>Read the instructions carefully and check your input.<br><br></body></html>");
		}
	}
}
