-- table for customer database
create table customer (cust_id varchar(30) not null,
                       fname varchar(30)  not null,
		       mname varchar(30),
		       lname varchar(30) not null,
		       dbirth date not null,
		       city   varchar(30) not null,
		       zipcode varchar(30) not null,
                       hno  varchar(30) not null,
		       desg varchar(30),
		       phno varchar(30),
		       email_id varchar(50), 
		       pr1 varchar(30) not null,
		       pr2 varchar(30) not null,
		       ds1 varchar(50) not null,
		       ds2 varchar(50) not null,
		       ds  varchar(50) not null,
		       primary key (cust_id) );

--table  for branch database		       
create table branch (branch_name varchar(30) not null,
                      city varchar(30) not null,
		      assets integer not null,
		      primary key (branch_name) 
		       );

-- table fro employee database
create table employee (emp_id varchar(30) not null,
                       fname varchar(30)  not null,
		       mname varchar(30),
		       lname varchar(30) not null,
		       dbirth date not null,
		       branch_name varchar(30) not null,
                       desg varchar(30),
		       hno  varchar(30) not null,
		       city varchar(30) not null,
		       zipcode varchar(30) not null,
		       rphno varchar(30),
		       ophno varchar(30) not null, 
		       email_id varchar(30), 
		       ds varchar(50) not null,
		       st_dat date not null,
	               primary key (emp_id),	       
        	       foreign key (branch_name) references branch (branch_name) on delete cascade
                       );
--table for account database
create table account (acc_no varchar(30) not null,
                       ac_nicnm varchar(30),
		       balance integer,
		       branch_name varchar(30) not null,
		       st_date date,
		       primary key (acc_no),
		       foreign key (branch_name) references branch (branch_name) on delete cascade 
		       );
--table for relation depositor		       
create table depositor (acc_no varchar(30) not null,
                        cust_id varchar(30) not null,
		        primary key (acc_no,cust_id),
		        foreign key (acc_no) references account (acc_no) on delete cascade,
		        foreign key (cust_id) references customer(cust_id) on delete cascade 
		       );
--table for loan database
create table loan (loan_no varchar(30) not null,
                    amount integer not null, 
		    interest_rate  number(4,2) not null,
		    period integer not null,
		    branch_name varchar(30) not null,
		    loan_date  date not null,
		    primary key (loan_no),
		    foreign key (branch_name) references branch (branch_name) on delete cascade 
		  );
--table for relation borrower		       
create table borrower (loan_no varchar(30) not null,
                        cust_id varchar(30) not null,
			primary key (loan_no , cust_id),
		        foreign key (loan_no) references loan (loan_no) on delete cascade, 
		         foreign key (cust_id) references customer (cust_id) on delete cascade 
		       );

--table for payment of loan ; weak entity 
create table payment (payment_no varchar(30) not null ,
                      loan_no varchar(30) not null,
		      payment_date date not null,
		      payment_amount integer not null,
	              foreign key (loan_no) references loan (loan_no)  	      
		      );
                        	
--table for transaction
create table transaction (serial_no varchar(30) not null,
			  acc_no varchar(30) not null,
			  mod varchar(30),
			  dat date not null,
			  amount integer not null,			  
			  primary key (serial_no),
			  foreign key (acc_no) references account (acc_no) on delete cascade
			  );

---table for atm
create table atm (serial_no varchar(30) not null,
                  acc_no varchar(30) not null,
		  passwd varchar(50) not null,
		  primary key (serial_no),
                  foreign key (acc_no) references account (acc_no) on delete cascade 
		   );

---table for cheque
create table cheque (chno integer not null,
                    acc_no varchar(30) not null,
                    amount integer not null,
		    ds varchar(50) not null,
		    primary key (chno),
		    foreign key (acc_no) references account (acc_no) on delete cascade
		    );

---table for cust_banker
create table cust_banker( cust_id varchar(30) not null,
                          emp_id varchar(30) not null,
			  primary key (cust_id , emp_id),
			  foreign key (cust_id) references customer (cust_id) on delete cascade, 
			  foreign key (emp_id) references employee (emp_id) on delete cascade 
			  );

