import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import javax.servlet.*;
import java.sql.*;
import HtmlPage.*;
/* This establishes the connection */
public class EvalServlet extends LoginServlet
{
	
	 private PrintWriter out;
	 private int asize,rsize;
	 private String tests[],testfiles[],readytests[],readytestfiles[];
 	 private Statement stmt;

	 public void init(ServletConfig config) throws ServletException
	{  
				super.init(config);
	 }

	 public synchronized void doGet(HttpServletRequest req,HttpServletResponse res) throws
		  					IOException,ServletException
	{
	
		 
		 res.setContentType("text/html");
		 out=res.getWriter(); 

		 if ( availableTests(con) )
		 {
		   	 HtmlPage nextPage=new HtmlPage();
			 int flag = Integer.parseInt(req.getParameter("flag"));
			 switch(flag){
				  case 1:
					   //shows the page for evaluation scheme
		 			generateSchemePage(nextPage);
					break;

			 	 case 2:
					  //shows the page for conducting analysis od results and view
					  //reports
					generateAnalysePage(nextPage);
					break;
			 }
		 }

	}
	
	 public void doPost(HttpServletRequest req,HttpServletResponse res) throws
		  					IOException,ServletException
	{ 
		 doGet(req,res);
	}

	 public boolean availableTests(Connection con)
	 {
		try{
			   
		  Statement stmt = con.createStatement() ;
		  ResultSet rs;
		  //determining the size of the array of test titles
		  String countQuery="select count(*) from test";
		  rs=stmt.executeQuery(countQuery);
		  
		  rs.next();
		  asize=rs.getInt(1);

		  tests=new String[asize];
		  testfiles=new String[asize];

		  //determining the test titles
		  String readQuery="select title,htmlfile from test";

		  rs=stmt.executeQuery(readQuery);
		  
		  for  (int i=0;i<asize;i++)
		  {
			   rs.next();
			   tests[i]=rs.getString(1);
			   testfiles[i]=rs.getString(2);
		  }

		  countQuery="select count(distinct test_title) from grade_scheme";
		  
		  rs=stmt.executeQuery(countQuery);
		  
		  rs.next();
		  rsize=rs.getInt(1);

		  readytests=new String[rsize];
		  readytestfiles=new String[rsize];

		  //determining the test titles
		  readQuery="select distinct title,htmlfile from test,grade_scheme"
			   				+" where test.title like grade_scheme.test_title";

		  rs=stmt.executeQuery(readQuery);
		  
		  for  (int i=0;i<rsize;i++)
		  {
			   rs.next();
			   readytests[i]=rs.getString(1);
			   readytestfiles[i]=rs.getString(2);
		  }
		  
		  return true;
		}catch(SQLException e)
		{ 
			 HtmlPage errorPage=new HtmlPage();
			 errorPage.printError(out,"SQL Exception","Can not execute Query",e);
			 return false;
		
		}

			 

	 }

	 public void generateSchemePage(HtmlPage evalSchemePage)
	 {
		
		evalSchemePage.startPage("Evaluation Scheme");
		evalSchemePage.setMenuItem("<h2>Available Tests</h2>");
			HtmlPage availableTestPage=new HtmlPage();
			if (asize!=0)
			for (int i=0;i<asize;i++)
			{
				availableTestPage.addElt("<a href=\"http://"+HTMLHOME+"tests/"+testfiles[i]+"\">"
						  +"<h3><font color=red>"+tests[i]+"</font></h3>\n</a></td>\n");
				availableTestPage.addTableData("");
				availableTestPage.addElt("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalScheme?flag=0&test="+tests[i]+"\">"
						  +"<h3><font color=red>Evaluation Scheme</font></h3>\n</a>");
				evalSchemePage.setMenuItem(availableTestPage);
			}
			else evalSchemePage.setMenuItem("<b>NO TESTS READY</b>");
		evalSchemePage.startBody();
		evalSchemePage.setBodyItem("Select anyone among the tests mentioned.");
		evalSchemePage.setBodyItem("You can also edit the earlier specified evaluation scheme.");
		evalSchemePage.startFooter();
		evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"mainMenu.html\">Main Menu</a>");
		evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"evalMenu.html\">Evaluation Menu</a>");
		evalSchemePage.setFooterItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/LogoutServlet\">LOGOUT</a>");
		evalSchemePage.endPage(HTMLHOME);
		
		evalSchemePage.printHtml(out);

	 }

	 public void generateAnalysePage(HtmlPage evalAnalysePage)
	 {
	
		evalAnalysePage.startPage("Evaluation Analysis");
		evalAnalysePage.setMenuItem("<h2>Available Tests</h2>");
			HtmlPage availableTestPage=new HtmlPage();
			if (rsize!=0)
			for (int i=0;i<rsize;i++)
			{
				availableTestPage.addElt("<a href=\"http://"+HTMLHOME+"tests/"+readytestfiles[i]+"\">"
						  +"<h3><font color=red>"+readytests[i]+"</font></h3>\n</a>");
				availableTestPage.addTableData("");
				availableTestPage.addElt("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=0&test="+readytests[i]+"\">"
						  +"<h3><font color=red>Evaluation Analysis</font></h3>\n</a>");
				
				evalAnalysePage.setMenuItem(availableTestPage);
			}
			else evalAnalysePage.setMenuItem("<b>NO TESTS READY</b>");
		evalAnalysePage.startBody();
		evalAnalysePage.setBodyItem("Select anyone among the tests mentioned.");
		evalAnalysePage.setBodyItem("You can view analysis in different forms as per your choice");
		evalAnalysePage.startFooter();
		evalAnalysePage.setFooterItem("<a href=\"http://"+HTMLHOME+"mainMenu.html\">Main Menu</a>");
		evalAnalysePage.setFooterItem("<a href=\"http://"+HTMLHOME+"evalMenu.html\">Evaluation Menu</a>");
		evalAnalysePage.setFooterItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/LogoutServlet\">LOGOUT</a>");
		evalAnalysePage.endPage(HTMLHOME);
		
		evalAnalysePage.printHtml(out);
	

	 }

//class ends
}
