drop table  q_in_paper ;
drop table options ;
drop table section ;
drop table question ;
drop table grade_report;
drop table grade_scheme;
drop table test_response;
drop table test;
drop table question_paper ;
drop table class;
drop table lab;
drop table student;

Create table question (id number primary key , body varchar(1000) not null, opt_count number
                              check (opt_count >= 1) , ans varchar(50)  , keyword  varchar(100));
								  

Create table options (id number , opt_no number not null , choice varchar(100) ,
                      foreign key (id) references question on delete cascade); 

Create table question_paper (id number not null , instr  varchar(1000) , 
                                        qpaper_title  varchar(100) primary key, total_marks number ,
											  section_count number );

Create table section (qpaper_title varchar(100) , serial_no number ,section_title varchar(20) , 
                      instr varchar (1000), 
					  primary key (qpaper_title , section_title),
					  foreign key (qpaper_title) references question_paper  on delete cascade); 

Create table q_in_paper (qpaper_title varchar(100),section_title varchar(20),
                         q_id number , serial_no number ,marks number ,
						 foreign key (qpaper_title,section_title)  references section on delete cascade ,
						 foreign key (q_id) references question on delete cascade );

Create table student(rollno varchar(10),
	 	 name varchar(50),email_id varchar(50),primary key (rollno)) ;


Create table class (class_name varchar(40) ,rollno varchar(10),
		foreign key (rollno) references student on delete cascade);

Create table lab (name varchar(50) ,terminal varchar(15));


 Create table test (title varchar(30) primary key ,htmlfile varchar(100),qpaper_title varchar(100),
		 lab_name varchar(30),class_name varchar(30),start_time varchar(20),
		 duration number,
		 foreign key (qpaper_title) references question_paper on delete
		 cascade);


Create table test_response(test_title varchar(100),rollno varchar(10),
	 	 question_no number,choice varchar(50),marks number,  
		 primary key(test_title,rollno,question_no),
		 foreign key(test_title) references test on delete cascade,
		 foreign key(rollno) references student on delete cascade);

Create table grade_scheme(test_title varchar(100),GRADE VARCHAR(10), 
	     weightage float(4),range_floor number,range_ceiling number, 
		 primary key(GRADE,test_title),foreign key(test_title) references test on delete cascade);

Create table grade_report(test_title varchar(100), rollno varchar(10),
	 	 grade varchar(10),percentile float(4),total_marks number,primary key(test_title,rollno),
		 foreign key(test_title) references test on delete cascade,
		 foreign key(rollno) references student on delete cascade) ;

 
		
-- insert into question values(1,'ilu',4,2,'lu');
-- insert into options values(2,1,'lu');
-- insert into options values(2,1,'lu');
--Create trigger q_del on delete from question
--     for 




											  
