/* This server handles actions related the the administrators */



import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;


public class AdminServlet extends CommonServlet
{
	private int newbillno = -1000;
	private int newreciptno = -1000;
	private java.util.Date curdate = null;
	String email = null;
	int smtpport = 0;
    public String SName()
	{
		return "http://" + hostname + ":" + serverport +
			"/servlet/AdminServlet";
	}
								
	
	public synchronized void checkDate()
	{
		java.util.Date d = new java.util.Date();
		if (d.getDate() == curdate.getDate())
			return;
		curdate = d;
		newbillno = 0;
		newreciptno = 0;
	}
	public synchronized int getNewBillNo()
	{
		checkDate();
		return newbillno++;
	}
	public synchronized int getNewReciptNo()
	{
		checkDate();
		return newreciptno++;
	}
	private void initNewBillNo() throws Exception
	{
	  //Find out the max billno for today
	  Statement stmt = null;
	  ResultSet rs = null;
	  Exception ex = null;
	  try
	  {
		curdate = new java.util.Date();
		stmt = conn.createStatement();
		rs = stmt.executeQuery("select max(billno) from bills " +
			"where entrydate=to_date('" + Utility.toString(curdate) + 
			"', 'dd-mm-yyyy')");
		if (rs.next())
			newbillno = rs.getInt(1) + 1;
		else
			newbillno = 1;
		rs = stmt.executeQuery("select max(recptno) from paydetails " +
			"where paytdate=to_date('" + Utility.toString(curdate) + 
			"', 'dd-mm-yyyy')");
		if (rs.next())
			newreciptno = rs.getInt(1) + 1;
		else
			newreciptno = 1;
		System.out.println("New Bill no : " + newbillno);
		System.out.println("New ReciptNo no : " + newreciptno);
	  }
	  catch (Exception e)
	  {
	  	ex = e;
	  }
	  try
	  {
		stmt.close();
		rs.close();
	  }
	  catch (Exception e) {}
	  if (ex != null)
	  	throw ex;
	}

	public synchronized void init(ServletConfig config) throws ServletException
	{
		try
		{
			super.init(config);
			initCommon();
			initNewBillNo();
			email = getInitParameter("email");
			try
			{
				smtpport = Utility.toInt(getInitParameter("smtpport"));
			}
			catch (NumberFormatException e)
			{
				throw new Exception("Invalid no given for SMTP Port");
			}
			if (email == null)
				throw new Exception("EMail address is not given");
		}
		catch (Exception e)
		{
			System.out.println("Error: " + e);
			System.exit(0);
		}
	}
	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
        PrintWriter toClient = res.getWriter();
		FileInputStream inp = null;
		String fn;
		try
		{	
			String s = req.getParameter("httpfile"),
				ss = req.getParameter("cssfile"),
				axn = req.getParameter("action");
        	HttpSession session = req.getSession(true);
      		Object obj = session.getValue("object");
			Vector termlist = null;
			if (obj != null && (obj instanceof Admin))
				termlist = ((Admin)obj).termlist;
			if (s != null || (axn == null && ss == null))
			{
       			res.setContentType("text/html");
				if (s == null)
					fn = "adminlogin.html";
				else if (obj == null)
					throw new Exception("You have not been logged in");
				else
					fn = s;
				putHtml(toClient, fn, termlist);
			}
			else if (axn != null)
			{
     			res.setContentType("text/html");
				if (obj == null)
					throw new Exception("You have not been logged in");
				else if (obj instanceof RootAdmin)
					((RootAdmin)obj).doGet(req, toClient, this);
				else if (obj instanceof DeptAdmin)
					((DeptAdmin)obj).doGet(req, toClient, this);
				else if (obj instanceof CashAdmin)
					((CashAdmin)obj).doGet(req, toClient, this);
				else if (obj instanceof SalaryAdmin)
					((SalaryAdmin)obj).doGet(req, toClient, this);
			}
			else if (ss != null)
			{
        		res.setContentType("text/css");
				putHtml(toClient, ss, termlist);
				
			}
				
				
		}
		catch (Exception e)
		{
			toClient.println("<html><head><title>Error</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + SName() + "?cssfile=MyStyle1.css\"><body>");
			Utility.printError(toClient, e);
		}
	}
		
	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
      PrintWriter toClient = res.getWriter();
	  try
	  {
        res.setContentType("text/html");
        HttpSession session = req.getSession(true);
        Object obj = session.getValue("object");
		
		String formname = req.getParameter("formname");
		if (formname == null)
			throw new Exception("Invalid form");
		if (formname.equals("adminlogin"))
		{	
			Object rlogin = LoginValid(toClient, req.getParameter("id"),
				req.getParameter("passwd"));
			if (rlogin != null)
				session.putValue("object", rlogin);
			else
				throw new Exception("Login incorrect");
		}	
		else if (obj == null || !(obj instanceof Admin))
			throw new Exception("You have not been logged in");
		else if (obj instanceof RootAdmin)
			((RootAdmin)obj).doPost(req, toClient, this);
		else if (obj instanceof DeptAdmin)
			((DeptAdmin)obj).doPost(req, toClient, this);
		else if (obj instanceof CashAdmin)
			((CashAdmin)obj).doPost(req, toClient, this);
		else if (obj instanceof SalaryAdmin)
			((SalaryAdmin)obj).doPost(req, toClient, this);
	  }
	  catch (Exception e)
	  {
		toClient.println("<html><head><title>Error</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + SName() + "?cssfile=MyStyle1.css\"><body>");
		Utility.printError(toClient, e);
	  }
	}
	Object LoginValid(PrintWriter toClient, String id, String passwd)
		throws Exception
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		id  = id.toLowerCase();
		passwd = passwd.toLowerCase();
		String s = "select Password, AdminType from Admin where AdminId = '" +
			id + "'";
		stmt = conn.createStatement();
		rs = stmt.executeQuery(s);
		if (rs.next())
		{
			String p = rs.getString(1).toLowerCase(), 
				t = rs.getString(2).toLowerCase();
			stmt.close();
			if (p.equals(passwd))
			{
				if (t.equals("root"))
					return new RootAdmin(id, toClient, this);
				else if (t.equals("dept"))
					return new DeptAdmin(id, toClient, this);
				else if (t.equals("cash"))
					return new CashAdmin(id, toClient, this);
				else if (t.equals("salary"))
					return new SalaryAdmin(id, toClient, this);
			}
			else
				throw new Exception("Invalid Password");
		}
		else
			throw new Exception("Invalid LoginId");
	  }
	  catch (Exception e)
	  {
		try
		{
		  	stmt.close();
			rs.close();
		} catch (Exception e1){}
		throw e;
	  }
	  return null;
	}
}


