
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;

class Employee extends Person
{
	public Employee(String i, PrintWriter toClient, PersonServlet ss)
	{
		termlist = new Vector(4, 4);
		id = i; persontype = "employee";
		termlist.addElement("$USER$:" + id);
		ss.putHtml(toClient, "emplmain.html", termlist);
		
	}
	public void doPost(HttpServletRequest req, PrintWriter toClient, 
		PersonServlet ss)
	{
		String formname;
		if ((formname = req.getParameter("formname")) == null)
		{
			toClient.println("Error: Invalid form");
			return;
		}
		if (formname.equals("chpwperson"))
			ModifyPasswd(req, toClient, ss);
		else if (formname.equals("modifydetails"))
			ModifyDetails(req, toClient, ss);
		else
		{
			toClient.print("Error: Invalid form");
			return;
		}
	}

	public void doGet(HttpServletRequest req, PrintWriter toClient, 
		PersonServlet ss)
	{
		String action;
		if ((action = req.getParameter("action")) == null)
		{
			toClient.print("Error: Invalid form");
			return;
		}
		else if (action.equals("allpbillsinfo"))
			AllPBillsInfo(req, toClient, ss);
		else if (action.equals("modifydetailsreq"))
			ModifyDetailsReq(req, toClient, ss);
		else if (action.equals("calcsalary"))
			CalcSalary(req, toClient, ss);
		else if (action.equals("loandetails"))
			LoanDetails(req, toClient, ss);
		else if (action.equals("leavedetails"))
			LeaveDetails(req, toClient, ss);
		else
		{
			toClient.print("Error: Invalid action");
			return;
		}
	}
	void ModifyDetailsReq(HttpServletRequest req, PrintWriter toClient,
	      PersonServlet ss)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of Employee " +
			id + " </title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + ss.SName() + "?cssfile=MyStyle1.css\"><body>");
	  	stmt = ss.conn.createStatement();
		rs = stmt.executeQuery("select Name,Address," +
		"AcctNo,email from Employee where ID = '" + id + "'");
		rs.next();

		toClient.println("<form action=http://" + ss.hostname + ":" + ss.serverport + "/servlet/EmployeeServlet method=POSt>");
		toClient.println("<input type=hidden name=formname value=\"modifydetails\">" +
			"<table><tr><th>Your Name<td><input type=text name=studentname value=\"" + rs.getString(1) + "\"></tr>" +
			"<tr><th>Your Address<td><input type=text name=address value=\"" + rs.getString(2) + "\"></tr>" +
			"<tr><th>Your AcctNo<td><input type=text name=acctno value=\"" + rs.getString(3) + "\"></tr>" +
			"<tr><th>Your Email<td><input type=text name=email value=\"" + rs.getString(4) + "\"></tr>");
		toClient.println("</table><br><input type=submit value=\"Modify\">");
		toClient.println("</form></body></html>");
	  }
	  catch (Exception e)
      {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e){}
	}
	void ModifyDetails(HttpServletRequest req, PrintWriter toClient,
	      PersonServlet ss)
	{
	  Statement stmt = null;
	  try
	  {
		toClient.println("<html><head><title>Response to Modify Details</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + ss.SName() + "?cssfile=MyStyle1.css\"><body>");
		stmt = ss.conn.createStatement();
		String name = req.getParameter("studentname").trim().toLowerCase(),
			    acctno = req.getParameter("acctno").trim().toLowerCase(), 
			    address = req.getParameter("address").trim().toLowerCase(), 
			    email = req.getParameter("email").trim().toLowerCase();
		if (name.length() == 0 || address.length() == 0)
			throw new Exception("You have not given the name/address");
		stmt.executeUpdate("update Student set name = '" + name +
			"',address ='" + address + "',acctno ="  + acctno + ",email ='" +
			email + "'");
		try
		{
			toClient.print("<title>Details modified</title>"+
				"Details of Student <b>" + name + "</b>" +
				"</b> has been succesfully modified<br><br>");
		}
		catch (Exception e)
		{
			toClient.print("Exception: " + e);
		}
	  }
	  catch (Exception e)
	  {
	  	Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	  } catch (Exception e){}
	}
	void CalcSalary(HttpServletRequest req, PrintWriter toClient, 
		PersonServlet as)
	{
      Connection conn = null;
	  Statement stmt1 = null;
	  ResultSet rs= null;
	  try
	  {
	  	String action = "view";
		conn = as.getNewConnection();
		conn.setAutoCommit(false);
		stmt1 = conn.createStatement();
	  	java.util.Date CurrentMonth = Utility.getCurrentMonthDate();
		String currentmonth = Utility.toString(CurrentMonth);
	  	rs = stmt1.executeQuery("select SalaryCode,PrvIncrDate," +
			"CurPayStage, LowerLimit, Increment1, MiddleLimit, Increment2, " +
			" UpperLimit, HasWorkedAfterIncr, LastIncrAmount, " +
			" LastCalculated, HasOwnHouse, Employee.Post, designation.Grade, " +
			" Sex, Address, TISinceMarch, HRASinceMarch, ITPaid " +
			" from Employee,Designation,Payscale " +
	  		" where Employee.post = Designation.post and " +
			" Designation.grade = Payscale.grade" +
			" and employee.id = '" + id + "'");
		SalaryClass.CalcSalary(req, toClient, as, conn, rs, action, null, 
			CurrentMonth, "flat-style");
		rs.close();
		conn.close();
	  }
	  catch (Exception e)
	  {
	  	try
		{
			conn.rollback();
			conn.close();
			stmt1.close();
			rs.close();
		}
		catch (Exception e1) {}
		toClient.println("<br>Error:" + e);
		e.printStackTrace();
 	  }
	}
 	void LeaveDetails(HttpServletRequest req, PrintWriter toClient,
	      PersonServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of Leave </title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
			
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select Employee.SalaryCode,LeaveType," +
		"FromD,ToD from Employee,Leave where ID = '" + id + "'" + 
		" and Employee.SalaryCode = Leave.SalaryCode and MonthConsidered is null");
		toClient.println("<table><tr><th>Type Of Leave<th>Taken Date<th>Till Date");
		while (rs.next())
		{
			toClient.println("<tr><td>" + rs.getString(2) +
				"<td>" + Utility.toString(rs.getDate(3)) +
				"<td>" + Utility.toString(rs.getDate(4)));
		}
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
      {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	    rs.close();
	  } catch (Exception e){}
	}

	void LoanDetails(HttpServletRequest req, PrintWriter toClient,
	      PersonServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		toClient.println("<html><head><title>Details of Loan </title>" +
			"</head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
		stmt = as.conn.createStatement();
		rs = stmt.executeQuery("select Employee.SalaryCode,LoanId," +
			"Type,DateTaken,PayInSalary,AmountTaken,DueAmount," +
			"InterestAccumulated,DedQuantum,RecoveryStart from " +
			"Employee,Loan where ID = '" + id + "'" + 
			" and Employee.SalaryCode = Loan.SalaryCode ");
		rs.next();
		toClient.println("<table><tr>" +
			"<th>Loan Id<th>Type Of Loan<th>Taken Date" +
			"<th>Pay Through Salary<th>Amount Taken<th>" +
			"Due Amount<th>Interest Accumulated" +
			"<th>Deduce Quantum<th>Months Gap For Recovery");
		toClient.println("<tr>" +
			"<td>" + rs.getString(2) +
			"<td>" + rs.getString(3) +
			"<td>" + Utility.toString(rs.getDate(4)) +
			"<td>" + rs.getString(5) +
			"<td>" + rs.getString(6) +
			"<td>" + rs.getString(7) +
			"<td>" + rs.getString(8) +
			"<td>" + rs.getString(9) +
			"<td>" + rs.getString(10) );
		toClient.println("</table></body></html>");
	  }
	  catch (Exception e)
      {
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
	    rs.close();
	  } catch (Exception e){}
	}

	
}		

