package DBIS.Configurator;

import java.util.*;
import java.io.*;
import java.sql.*;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;   
import DBIS.Tools.Debugger;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Configurator.Configurable;
import DBIS.Configurator.SqlScripts;

/** This contains the configurator for the BussinessMan's
 * interface This is menu driven configurator It provides
 * the bussiness man with the following functionalities :
 * 1 Insert/Delete/Update elements in his table - one tuple at a time
 * 2 View the items stored in the database
 * 3 Define aliases for personalised usage
 * 4 To construct the html pages 
 */

public class Configurator {

	static	{
//		Debugger.addClass("DBIS.Configurator.Configurator");
	}

	/** This contains the classes required for the constructor of 
	 * the configurable option class*/
	Class[] classArr=new Class[1];
	/** This contains the parameters for the configurable option
	 * object */
	Object[] objectArr=new Object[1];

	/** This contains entries for the options */ 
	Hashtable hashtable=new Hashtable();

	/** This contains the name of the table which contains the options*/
	String tableName="ConfigureOptions";

	 /* These can be changed later to suit servlets*/
	public Configurator()	{
		initialise();
	}

	public Configurator(String tableName)	{
		this.tableName=tableName;
		initialise();
	}

	/** All the intialisations are done at this stage*/
	public synchronized void initialise()	{
		String options="select * from "+tableName;
		ResultSet rs=QueryEngine.executeQuery(options);
		int it=0;
		try {
			while(rs.next())	{
				String[] arr=new String[2];
				for(int i=0;i<2;arr[i++]=rs.getString(i));
				hashtable.put(new Integer(it++),arr);
			}
		}
		catch(Exception e) {e.printStackTrace();}
		try {
			classArr[0]=Class.forName("DBIS.Configurator.Configurator");
		}catch(ClassNotFoundException e) {e.printStackTrace();}

		objectArr[0]=this;
	}
	
	public synchronized void configure()	{
		while(true)	{
			printHeader();
			printMenu();
			System.out.print("\tEnter your choice : ");
			DataInputStream din=new DataInputStream(System.in);
			try {
				String str=din.readLine();
				handle(str);
			}
			catch(Exception e) {e.printStackTrace(); return;}
		}
	}

	public void handle(String str)	{
		Integer num;
		try {
			num=Integer.decode(str.trim());	
			num=new Integer(num.intValue()-1);
		}
		catch(Exception e) {System.out.print("Invalid choice. Please enter a number\n"); return;}

		String[] arr=(String[])hashtable.get(num);
		if(arr==null)	{
			System.out.print("Invalid Option\n");
			return;
		}
		Class optionClass;
		try {
			optionClass=Class.forName(arr[1]);
		}
		catch(Exception e) {
			e.printStackTrace();
			System.out.println("Class -> "+arr[1]);
			return;
		}

		Configurable tmp=null;
		try	{
			tmp=(Configurable)optionClass.getConstructor(classArr).newInstance(objectArr);
		}
		catch(Exception e) {e.printStackTrace();}

		tmp.configure();
	}

	protected void printHeader()	{
		System.out.print("\n");
		String menuFile=Singleton.getInstance().getWelcomeMenuFile();
		try {
			FileInputStream fio=new FileInputStream(menuFile);
			int num=fio.available();
			byte[] arr=new byte[num];
			fio.read(arr);
			String str=new String(arr,0);
			System.out.print(str+"\n");
		}
		catch(Exception e) {
			e.printStackTrace();
			return;
		}
	}

	protected void printMenu()	{
		int it=0;
		String[] arr;
		while((arr=(String[])hashtable.get(new Integer(it++)))!=null)	{
			Debugger.display("Adding : "+arr[0]+" : "+arr[1],getClass());
			System.out.print("\t"+it+".\t"+arr[0]+"\n");
		}
	}

	public static void main(String args[])	{
		(new Configurator()).configure();
	}
}
