package DBIS.Configurator; 

import java.io.DataInputStream;
import DBIS.Configurator.Insert; 
import DBIS.Configurator.Query; 
import DBIS.Configurator.Delete; 

public class Menu	{
	
	public static void displayMenu()	{
		System.out.println(	"Menu");
		System.out.println(	"Insert	:	i");
		System.out.println(	"Delete	:	d");
		System.out.println(	"Help	:	h");
		System.out.println(	"Quit	:	q");
		System.out.print( "Your Choice : ");
		return;
	}

	public static void main(String[] args)	{
		DataInputStream din=new DataInputStream(System.in);
		while(true)	{
			try {	
				displayMenu();
				String str=din.readLine();
				if(str.equals("q"))	break;
				handle(str);
			}catch(Exception e) { e.printStackTrace();} 
		}
	}

	public static void handle(String str)	{
		DataInputStream din=new DataInputStream(System.in);
		System.out.print("Enter the table name : ");
		try {	
			String table=din.readLine();
			if(str.equals("i"))	{
				(new Insert()).runInsert(table);
				return;
			}
			if(str.equals("d"))	{
				System.out.println("Enter the predicate for delete :");
				String pred=din.readLine();
				String[] args={table,pred};
				Delete.main(args);	
				return;
			}
			if(str.equals("h"))	{
				String[] args={table};		
				Help.main(args);
			}
		}catch(Exception e) {System.out.println("Invalid SQL Query ... try again");}
	}
}
