package DBIS.Configurator.ConfigurationMenu;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.ErrorPageGenerator;
import DBIS.Tools.ConfirmationPageGenerator;
import DBIS.Configurator.MenuHandler;
import DBIS.Configurator.MenuManager;
import DBIS.Tools.ConfirmationPageGenerator;

/** This class handles the main menu of Data browse menu*/
public class MainMenuHandler extends MenuHandler {

	public MainMenuHandler(ServletRequest request)	{
		super(request);
	}

	protected void initialise()	{
		menuName="ConfigurationMenu";
	}

	public String handleRequest()	{
		String toReturn=super.handleRequest();
		if(toReturn!=null)	return toReturn;

		String option=request.getParameter("option");
		String type=request.getParameter("type");
		if(option.equals("TemplateFiles"))	{
			toReturn=(new TemplateFiles()).format();
		}
		else if(option.equals("ChangePassword"))	{
			toReturn=(new ConfirmationPageGenerator("<b><font size=+2>Sorry due to security "+
							"reasons you are not allowed to changed "+
							"password from web interface</font></b>")).format();
		}
		return toReturn;
	}
}
