package DBIS.Components;

import java.sql.*;
import java.util.Vector;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;

/** This contains the code to get general purpose information about
 *  a particular item This class operates via static functions The required
 *  queries can  be invoked thru appropriate static functions*/
public class Item {
	
	int item_id;	
	String name;
	String price;
	String preview_url;
	String description;


	public Item(ResultSet rs)	{
		initialise(rs);
	}
	
	public Item(int item_id)	{
		this.item_id=item_id;
		try {	
			String query=Singleton.DBIS_SQL_INCOM_DBISPRODUCTNAME+item_id;
			ResultSet rs=QueryEngine.executeQuery(query);
			if(rs==null)	throw new SQLException();
			initialise(rs);
		}catch(SQLException sqle){ System.out.println("Exception " + sqle); return;}
	}

	public void initialise(ResultSet rs)	{
		try {	
			rs.next();
			name=rs.getString(2);
			price=rs.getString(3);
			preview_url=rs.getString(4);
			description=rs.getString(5);
		}catch(SQLException sqle){ System.out.println("Exception " + sqle); return;}
		return;
	}

	public int getItemId()	{	return item_id;}
	public String getName()	{	return name;}
	public String getPrice()	{	return price;}
	public String getPreviewURL()	{	return preview_url;}
	public String getDescription()	{	return description;}

	public void display()	{
		System.out.println("item_id:       "+	item_id);
		System.out.println("name:          "+  name);   
		System.out.println("price:         "+  price);      
		System.out.println("preview_url:   "+  preview_url);
		System.out.println("description: 	"+description);
		return;
	}
	
	public static void main(String args[])	{
		Item item;
		for(int i=1;i<8;i++)	{
			(item=new Item(i)).display();
		}
	}
}
