package DBIS.Configurator.DBM;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.io.FileInputStream;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.HtmlTemplate;


public class Browse extends PageGenerator 	{

	String query=null;
	String tableName="Result";
	static HtmlTemplate _template;

	/** This static block loads the template file and stores
	 * it once for all for further instances*/
	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_CONFIGURATOR_TABLEINFOFILE);
	}
	
	public Browse(String query)	{
		super(Browse._template);
		this.query=query;
	}

	public Browse(String query,String tableName)	{
		super(Browse._template);
		this.query=query;
		this.tableName=tableName;
	}

	public Browse(HtmlTemplate _template,String query,String tableName)	{
		super(_template);
		this.query=query;
		this.tableName=tableName;
	}

	public Browse(HtmlTemplate _template,String query)	{
		super(_template);
		this.query=query;
	}

	/** In this case we are overloading the format function Basically
	 * the AllPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(getHtmlTemplate().getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();

		String query=this.query;
		ResultSet rs=QueryEngine.executeQuery(query);
		if(rs==null)	{
			while(enumeration.hasMoreElements())	{
				hashtable.put((String)enumeration.nextElement(),"Unknown");
			}
			return hashtable;
		}
		String allItemsLink="";
		String table="<table BORDER=2 CELLSPACING=1 CELLPADDING=1 >\n";
		try {
			int colNum=0;
			ResultSetMetaData rsmd;
			colNum=(rsmd=rs.getMetaData()).getColumnCount();
			String titleRow="<tr>";

			for(int i=1;i<=colNum;i++)	{
				titleRow+="<td><b>";
				titleRow+=rsmd.getColumnName(i);
				titleRow+="</b></td>";
			}
			titleRow+="</tr>";
			table+=titleRow;
			while(rs.next())	{
					table+="<tr>";
					table+=getRow(rs);
					table+="</tr>\n";
			}
		}catch(SQLException e) {e.printStackTrace();}
		table+="</table>\n";
		while(enumeration.hasMoreElements())	{
			String element=(String)enumeration.nextElement();
			String tag="";
			if(element.equals("$$DBIS_CONFIGURATION_TABLE$$"))	{
				tag=table;
			}
			if(element.equals("$$DBIS_CONFIGURATION_TABLENAME$$"))	{
				tag=tableName;
			}
			hashtable.put(element,tag);
		}
		return hashtable;
	}

	protected String getRow(ResultSet rs)	{
		String row="";
		try {
			ResultSetMetaData rsmd=rs.getMetaData();
			for(int i=1;i<=rsmd.getColumnCount();i++)	{
				row+="<td>";
				row+=rs.getString(i);
				row+="</td>";
			}
		}catch(SQLException e) {e.printStackTrace();}
		return row;
	}

	public static void main(String args[])	{
		System.out.println((new Browse("select * from Item")).format());
	}
}

