package DBIS.Configurator;

import java.sql.*;
import javax.servlet.ServletRequest;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import java.util.Enumeration;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PlotPageGenerator;
import DBIS.Tools.ErrorPageGenerator;
import DBIS.Configurator.MenuManager;
import DBIS.Configurator.Plotters.SinglePlotter;
import DBIS.Configurator.DBM.Browse;

/** This class contains the methods to handle request from
 * a menu */
abstract public class  MenuHandler	{

	protected ServletRequest request=null;
	protected String menuName=null;

	public MenuHandler(ServletRequest request)	{
		this.request=request;
		initialise();
	}

	protected void initialise()	{}


	/** This function returns the query pertaining to the given
	 * option from the SqlMenu table*/
	protected String handleSqlRequest(String option)	{
		ResultSet rs=QueryEngine.executeQuery("select sqlQuery from SqlMenu where discriminator=\'"+option+"\' and menuName=\'"+menuName+"\'");
		String query=null;
		try	{
			rs.next();
			query=rs.getString("sqlQuery");
		}catch(SQLException e) {query=null;}
		return query;
	}

	public String handleRequest()	{
		Vector paramVec=getParameterVector();
		if((!paramVec.contains("option"))||(!paramVec.contains("type")))	{
			MenuManager menuManager=new MenuManager(menuName);
			return menuManager.format();
		}
		String option=request.getParameter("option");
		String type=request.getParameter("type");
		String toReturn=null;
		if(type.equals("SqlQuery"))	{
			String query=handleSqlRequest(option);
			if(query==null)	return (new ErrorPageGenerator("Invalid query in DBM Menu")).format();
			Browse browse=new Browse(query,option);
			toReturn=browse.format();
		}
		else if(type.equals("SinglePlotter"))	{
			String query=handleSqlRequest(option);
			if(query==null)	return (new ErrorPageGenerator("Invalid query in DBM Menu")).format();
			String plotter=request.getParameter("plotterClass");
			try {
				Class handlerClass=Class.forName(plotter);
				Class[] classArr=new Class[1];
				classArr[0]=Class.forName("java.lang.String");
				Object[] objArr=new Object[1];
				objArr[0]=query;
				SinglePlotter instance=(SinglePlotter)handlerClass.getConstructor(classArr).newInstance(objArr);
				PlotPageGenerator plot=new PlotPageGenerator(instance.getAppletCode(),option);
				toReturn=plot.format();
			}
			catch(NoSuchMethodException e) {return (new ErrorPageGenerator("Error in DBM Menu")).format();}
			catch(SecurityException e) {return (new ErrorPageGenerator("Error in DBM Menu")).format();}
			catch(InstantiationException e) {return (new ErrorPageGenerator("Error in DBM Menu")).format();}
			catch(IllegalAccessException e) {return (new ErrorPageGenerator("Error in DBM Menu")).format();}
			catch(InvocationTargetException e) {return (new ErrorPageGenerator("Error in DBM Menu")).format();}
			catch(ClassCastException e) {return (new ErrorPageGenerator("Error in DBM Menu")).format();}
			catch(ClassNotFoundException e) {e.printStackTrace(); System.out.println("ClassNotFoundIs -->"+plotter);}
		}
		return toReturn;
	}

	protected Vector getParameterVector()	{
		Enumeration enumeration=request.getParameterNames();
		Vector paramVec=new Vector(1,1);
		while(enumeration.hasMoreElements())	{
			paramVec.addElement(enumeration.nextElement());
		}
		return paramVec;
	}

}
